/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.io.IOException;
import java.io.Writer;
import java.util.function.IntPredicate;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;

public class Slice16
extends UnicodeString {
    private char[] chars;
    private int start;
    private int end;
    private int cachedHash;

    public Slice16(char[] chars, int start, int end) {
        this.chars = chars;
        this.start = start;
        this.end = end;
    }

    @Override
    public long length() {
        return this.end - this.start;
    }

    @Override
    public int getWidth() {
        return 16;
    }

    public char[] getCharArray() {
        return this.chars;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public long indexOf(int codePoint, long from) {
        if (codePoint > 65535) {
            return -1L;
        }
        char b = (char)(codePoint & 0xFFFF);
        int limit = this.end;
        for (int i2 = this.start + Slice16.requireNonNegativeInt(from); i2 < limit; ++i2) {
            if (this.chars[i2] != b) continue;
            return i2 - this.start;
        }
        return -1L;
    }

    @Override
    public int codePointAt(long index) {
        int index32 = Slice16.requireInt(index);
        if (index32 < 0 || index32 >= this.length32()) {
            throw new IndexOutOfBoundsException();
        }
        return this.chars[this.start + index32];
    }

    @Override
    public UnicodeString substring(long start, long end) {
        this.checkSubstringBounds(start, end);
        if (end == start) {
            return EmptyUnicodeString.getInstance();
        }
        return new Slice16(this.chars, Slice16.requireInt(start) + this.start, Slice16.requireInt(end) + this.start);
    }

    private void write(Writer writer, long start, long len) throws IOException {
        writer.write(this.chars, this.start + Slice16.requireInt(start), Slice16.requireInt(len));
    }

    @Override
    public long indexWhere(IntPredicate predicate, long from) {
        for (int i2 = Slice16.requireNonNegativeInt(from) + this.start; i2 < this.end; ++i2) {
            if (!predicate.test(this.chars[i2])) continue;
            return i2 - this.start;
        }
        return -1L;
    }

    @Override
    void copy16bit(char[] target, int offset) {
        System.arraycopy(this.chars, this.start, target, offset, this.end - this.start);
    }

    @Override
    void copy24bit(byte[] target, int offset) {
        int i2 = this.start;
        int j = offset;
        while (i2 < this.end) {
            char c = this.chars[i2++];
            target[j++] = 0;
            target[j++] = (byte)(c >> 8);
            target[j++] = (byte)(c & 0xFF);
        }
    }

    @Override
    void copy32bit(int[] target, int offset) {
        int i2 = this.start;
        int j = offset;
        while (i2 < this.end) {
            target[j++] = this.chars[i2++];
        }
    }

    @Override
    public IntIterator codePoints() {
        return new IntIterator(){
            int i;
            {
                this.i = Slice16.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.i < Slice16.this.end;
            }

            @Override
            public int next() {
                return Slice16.this.chars[this.i++];
            }
        };
    }

    @Override
    public int hashCode() {
        if (this.cachedHash != 0) {
            return this.cachedHash;
        }
        int h = 0;
        for (int i2 = this.start; i2 < this.end; ++i2) {
            char b = this.chars[i2];
            h = 31 * h + b;
        }
        this.cachedHash = h;
        return this.cachedHash;
    }

    public String toString() {
        return new String(this.chars, this.start, this.end - this.start);
    }
}

