/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.IntPredicate;
import net.sf.saxon.Configuration;
import net.sf.saxon.serialize.UTF8Writer;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.Slice8;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;

public class Twine8
extends UnicodeString {
    protected byte[] bytes;
    protected int cachedHash = 0;
    private static final boolean CHECKING = Configuration.isAssertionsEnabled();

    public Twine8(byte[] bytes) {
        this.bytes = bytes;
    }

    public Twine8(char[] chars, int start, int len) {
        this.bytes = new byte[len];
        for (int i2 = start; i2 < len; ++i2) {
            char c = chars[i2];
            if (CHECKING && c > '\u00ff') {
                throw new IllegalArgumentException();
            }
            this.bytes[i2] = (byte)(chars[i2] & 0xFF);
        }
    }

    public Twine8(String str) {
        this.bytes = Twine8.fromString(str);
    }

    private static byte[] fromString(String str) {
        return str.getBytes(StandardCharsets.ISO_8859_1);
    }

    public byte[] getByteArray() {
        return this.bytes;
    }

    @Override
    public long length() {
        return this.bytes.length;
    }

    @Override
    public int length32() {
        return this.bytes.length;
    }

    @Override
    void copy8bit(byte[] target, int offset) {
        System.arraycopy(this.bytes, 0, target, offset, this.bytes.length);
    }

    @Override
    void copy16bit(char[] target, int offset) {
        int i2 = 0;
        int j = offset;
        while (i2 < this.bytes.length) {
            target[j++] = (char)(this.bytes[i2++] & 0xFF);
        }
    }

    @Override
    void copy24bit(byte[] target, int offset) {
        int i2 = 0;
        int j = offset;
        while (i2 < this.bytes.length) {
            target[j++] = 0;
            target[j++] = 0;
            target[j++] = this.bytes[i2++];
        }
    }

    @Override
    void copy32bit(int[] target, int offset) {
        int i2 = 0;
        int j = offset;
        while (i2 < this.bytes.length) {
            target[j++] = this.bytes[i2++] & 0xFF;
        }
    }

    @Override
    public UnicodeString substring(long start, long end) {
        long len = this.length();
        if (start < 0L || end < start || end > len) {
            throw new IndexOutOfBoundsException();
        }
        if (end == start) {
            return EmptyUnicodeString.getInstance();
        }
        if (start == 0L && end == len) {
            return this;
        }
        return new Slice8(this.bytes, Twine8.requireInt(start), Twine8.requireInt(end));
    }

    @Override
    public int codePointAt(long index) throws IndexOutOfBoundsException {
        int index32 = Twine8.requireInt(index);
        if (index32 < 0 || index32 >= this.length32()) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[index32] & 0xFF;
    }

    @Override
    public long indexOf(int codePoint, long from) {
        int from32 = Twine8.requireNonNegativeInt(from);
        if (from32 >= this.length32()) {
            return -1L;
        }
        int last = this.bytes.length;
        if (codePoint < 0 || codePoint > 255) {
            return -1L;
        }
        for (int i2 = from32; i2 < last; ++i2) {
            if ((this.bytes[i2] & 0xFF) != codePoint) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public long indexOf(UnicodeString other, long from) {
        if (from < 0L) {
            from = 0L;
        } else if (from >= this.length()) {
            return -1L;
        }
        if (other.isEmpty()) {
            return from;
        }
        int initial = other.codePointAt(0L);
        int len = Twine8.requireInt(other.length());
        int lastPossible = this.length32() - len;
        while (from <= (long)lastPossible) {
            long i2 = this.indexOf(initial, from);
            if (i2 < 0L) {
                return -1L;
            }
            if (this.hasSubstring(other, i2)) {
                return i2;
            }
            from = i2 + 1L;
        }
        return -1L;
    }

    @Override
    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    @Override
    public int getWidth() {
        return 8;
    }

    @Override
    public IntIterator codePoints() {
        return new IntIterator(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Twine8.this.bytes.length;
            }

            @Override
            public int next() {
                return Twine8.this.bytes[this.i++] & 0xFF;
            }
        };
    }

    @Override
    public int hashCode() {
        if (this.cachedHash != 0) {
            return this.cachedHash;
        }
        this.cachedHash = super.hashCode();
        return this.cachedHash;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Twine8) {
            Twine8 other = (Twine8)o;
            if (this.length32() != other.length32()) {
                return false;
            }
            if (this.hashCode() != other.hashCode()) {
                return false;
            }
            return Arrays.equals(this.bytes, other.bytes);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(UnicodeString other) {
        if (other instanceof Twine8) {
            Twine8 o = (Twine8)other;
            byte[] a = this.bytes;
            byte[] b = o.bytes;
            int len = Math.min(a.length, b.length);
            for (int i2 = 0; i2 < len; ++i2) {
                int diff = (a[i2] & 0xFF) - (b[i2] & 0xFF);
                if (diff == 0) continue;
                return diff;
            }
            return Integer.compare(a.length, b.length);
        }
        return super.compareTo(other);
    }

    public String toString() {
        return new String(this.bytes, StandardCharsets.ISO_8859_1);
    }

    private void write(Writer writer, long start, long len) throws IOException {
        if (writer instanceof UTF8Writer) {
            ((UTF8Writer)writer).writeLatin1(this.bytes, Twine8.requireInt(start), Twine8.requireInt(len));
        } else {
            writer.write(this.toString().substring(Twine8.requireInt(start), Twine8.requireInt(start + len)));
        }
    }

    @Override
    public long indexWhere(IntPredicate predicate, long from) {
        int i2 = Twine8.requireNonNegativeInt(from);
        while ((long)i2 < this.length()) {
            if (predicate.test(this.bytes[i2] & 0xFF)) {
                return i2;
            }
            ++i2;
        }
        return -1L;
    }

    public String details() {
        return "Twine8 bytes.length = " + this.bytes.length;
    }
}

