/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.io.IOException;
import java.util.Arrays;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.Twine16;
import net.sf.saxon.str.Twine24;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UniStringConsumer;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.UnicodeWriter;
import net.sf.saxon.str.ZenoString;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntIterator;

public final class UnicodeBuilder
implements UniStringConsumer,
UnicodeWriter {
    private int[] codepoints;
    private int used;
    private int bits;
    private ZenoString archive = ZenoString.EMPTY;

    public UnicodeBuilder() {
        this(256);
    }

    public UnicodeBuilder(int allocate) {
        this.codepoints = new int[allocate];
    }

    public UnicodeBuilder append(char ch) {
        this.append((int)ch);
        return this;
    }

    public UnicodeBuilder append(int codePoint) {
        this.ensureCapacity(1);
        this.codepoints[this.used++] = codePoint;
        this.bits |= codePoint;
        return this;
    }

    public UnicodeBuilder append(IntIterator codePoints) {
        while (codePoints.hasNext()) {
            this.append(codePoints.next());
        }
        return this;
    }

    public UnicodeBuilder appendLatin(String str) {
        return this.append(new BMPString(str));
    }

    public UnicodeBuilder appendAll(SequenceIterator iter) {
        Item item;
        while ((item = iter.next()) != null) {
            this.append(item.getUnicodeStringValue());
        }
        return this;
    }

    public UnicodeBuilder append(CharSequence str) {
        return this.append(StringTool.fromCharSequence(str));
    }

    public UnicodeBuilder append(UnicodeString str) {
        int len = str.length32();
        if (len == 0) {
            return this;
        }
        this.ensureCapacity(len);
        str.copy32bit(this.codepoints, this.used);
        this.used += len;
        int width = str.getWidth();
        if (width > 8) {
            this.bits = width > 16 ? (this.bits |= 0xFFFFFF) : (this.bits |= 0xFFFF);
        }
        return this;
    }

    public long length() {
        return this.archive.length() + (long)this.used;
    }

    public boolean isEmpty() {
        return this.archive.isEmpty() && this.used == 0;
    }

    private void ensureCapacity(int required) {
        if (this.used > 65535) {
            this.archive = this.archive.concat(this.getActivePart());
            this.used = 0;
            this.bits = 255;
        }
        while (this.used + required > this.codepoints.length) {
            this.codepoints = Arrays.copyOf(this.codepoints, this.codepoints.length * 2);
        }
    }

    public UnicodeString toUnicodeString() {
        if (this.archive.isEmpty()) {
            return this.getActivePart();
        }
        return this.archive.concat(this.getActivePart());
    }

    private UnicodeString getActivePart() {
        if ((this.bits & 0xFF0000) != 0) {
            return new Twine24(this.codepoints, this.used);
        }
        if ((this.bits & 0xFF00) != 0) {
            char[] chars = new char[this.used];
            for (int i2 = 0; i2 < this.used; ++i2) {
                chars[i2] = (char)(this.codepoints[i2] & 0xFFFF);
            }
            return new Twine16(chars);
        }
        byte[] bytes = new byte[this.used];
        for (int i3 = 0; i3 < this.used; ++i3) {
            bytes[i3] = (byte)(this.codepoints[i3] & 0xFF);
        }
        return new Twine8(bytes);
    }

    public StringValue toStringItem(AtomicType type) {
        return new StringValue(this.toUnicodeString(), type);
    }

    public String toString() {
        return this.toUnicodeString().toString();
    }

    public void clear() {
        this.archive = ZenoString.EMPTY;
        this.used = 0;
        this.bits = 0;
    }

    public static byte[] expand1to2(byte[] in, int start, int used, int allocate) {
        byte[] result = new byte[allocate * 2];
        int i2 = start;
        int j = 0;
        while (i2 < used) {
            result[j++] = 0;
            result[j++] = in[i2++];
        }
        return result;
    }

    public static char[] expandBytesToChars(byte[] in, int start, int end) {
        char[] result = new char[end - start];
        int i2 = start;
        int j = 0;
        while (i2 < end) {
            result[j++] = (char)in[i2++];
        }
        return result;
    }

    public static byte[] expand1to3(byte[] in, int start, int used, int allocate) {
        byte[] result = new byte[allocate * 3];
        int i2 = start;
        int j = 0;
        while (i2 < used) {
            result[j++] = 0;
            result[j++] = 0;
            result[j++] = in[i2++];
        }
        return result;
    }

    public static byte[] expand2to3(byte[] in, int start, int used, int allocate) {
        byte[] result = new byte[allocate * 3];
        int i2 = start;
        int j = 0;
        while (i2 < used) {
            result[j++] = 0;
            result[j++] = in[i2++];
            result[j++] = in[i2++];
        }
        return result;
    }

    public static byte[] expand(byte[] in, int start, int end, int oldWidth, int newWidth, int allocate) {
        if (allocate <= (end - start) / oldWidth) {
            allocate = (end - start) / oldWidth;
        }
        if (newWidth <= oldWidth) {
            byte[] out = new byte[allocate * newWidth];
            System.arraycopy(in, start, out, 0, end * oldWidth);
            return out;
        }
        if (oldWidth == 1 && newWidth == 2) {
            return UnicodeBuilder.expand1to2(in, start, end, allocate);
        }
        if (oldWidth == 1 && newWidth == 3) {
            return UnicodeBuilder.expand1to3(in, start, end, allocate);
        }
        if (oldWidth == 2 && newWidth == 3) {
            return UnicodeBuilder.expand2to3(in, start, end, allocate);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public UnicodeBuilder accept(UnicodeString chars) {
        return this.append(chars);
    }

    @Override
    public void write(UnicodeString chars) {
        this.append(chars);
    }

    @Override
    public void writeAscii(byte[] content) throws IOException {
        this.accept(new Twine8(content));
    }

    @Override
    public void write(String chars) throws IOException {
        this.append(chars);
    }

    public void trimToSize() {
        this.codepoints = Arrays.copyOf(this.codepoints, this.used);
    }

    @Override
    public void close() {
    }
}

