/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.trans.XPathException;

public class PackageVersion
implements Comparable<PackageVersion> {
    public List<Integer> parts;
    public String suffix;
    public static PackageVersion ZERO = new PackageVersion(new int[]{0});
    public static PackageVersion ONE = new PackageVersion(new int[]{1});
    public static PackageVersion MAX_VALUE = new PackageVersion(new int[]{Integer.MAX_VALUE});

    public PackageVersion(int[] values) {
        this.parts = new ArrayList<Integer>(values.length);
        for (int value : values) {
            this.parts.add(value);
        }
        this.trimTrailingZeroes();
    }

    private void trimTrailingZeroes() {
        for (int i2 = this.parts.size() - 1; i2 > 0; --i2) {
            if (this.parts.get(i2) != 0) {
                return;
            }
            this.parts.remove(i2);
        }
    }

    public PackageVersion(String s) throws XPathException {
        this.parts = new ArrayList<Integer>();
        String original = s;
        if (s.contains("-")) {
            int i2 = s.indexOf(45);
            this.suffix = s.substring(i2 + 1);
            if (!NameChecker.isValidNCName(this.suffix)) {
                throw new XPathException("Illegal NCName as package-version NamePart: " + original, "XTSE0020");
            }
            s = s.substring(0, i2);
        }
        if (s.equals("")) {
            throw new XPathException("No numeric component of package-version: " + original, "XTSE0020");
        }
        if (s.startsWith(".")) {
            throw new XPathException("The package-version cannot start with '.'", "XTSE0020");
        }
        if (s.endsWith(".")) {
            throw new XPathException("The package-version cannot end with '.'", "XTSE0020");
        }
        for (String p : s.trim().split("\\.")) {
            this.parts.add(PackageVersion.parseInteger(p));
        }
        this.trimTrailingZeroes();
    }

    public static int parseInteger(String s) throws XPathException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new XPathException("Error in package-version: " + e.getMessage(), "XTSE0020");
        }
    }

    public boolean equals(Object o) {
        if (o instanceof PackageVersion) {
            PackageVersion p = (PackageVersion)o;
            if (PackageVersion.equalParts(this.parts, p.parts)) {
                if (this.suffix != null) {
                    return this.suffix.equals(p.suffix);
                }
                return p.suffix == null;
            }
        }
        return false;
    }

    private static boolean equalParts(List<Integer> a, List<Integer> b) {
        return a.equals(b);
    }

    public int hashCode() {
        int h = 772211;
        for (int p : this.parts) {
            h = h << 3 ^ p;
        }
        if (this.suffix != null) {
            h = h << 3 ^ this.suffix.hashCode();
        }
        return h;
    }

    public boolean equalsIgnoringSuffix(PackageVersion other) {
        return this.parts.equals(other.parts);
    }

    @Override
    public int compareTo(PackageVersion o) {
        PackageVersion pv = o;
        List<Integer> p = pv.parts;
        int extent = this.parts.size() - p.size();
        int len = Math.min(this.parts.size(), p.size());
        for (int i2 = 0; i2 < len; ++i2) {
            int comp = this.parts.get(i2).compareTo(p.get(i2));
            if (comp == 0) continue;
            return comp;
        }
        if (extent == 0) {
            if (this.suffix != null) {
                if (pv.suffix == null) {
                    return -1;
                }
                return this.suffix.compareTo(pv.suffix);
            }
            if (pv.suffix != null) {
                return 1;
            }
        }
        return extent;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Integer i2 : this.parts) {
            result.append(".").append(i2);
        }
        if (!this.parts.isEmpty()) {
            result = new StringBuilder(result.substring(1));
        }
        if (this.suffix != null) {
            result.append("-").append(this.suffix);
        }
        return result.toString();
    }

    public boolean isPrefix(PackageVersion v) {
        if (v.parts.size() >= this.parts.size()) {
            for (int i2 = 0; i2 < this.parts.size(); ++i2) {
                if (this.parts.get(i2).equals(v.parts.get(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

