/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.iter.NodeListIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.PrimitiveUType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class KeyIndex {
    private final Map<AtomicMatchKey, Object> index;
    private UType keyTypesPresent = UType.VOID;
    private final UType keyTypesConvertedFromUntyped = UType.STRING_LIKE;
    private List<StringValue> untypedKeys;
    private ConversionRules rules;
    private int implicitTimezone;
    private StringCollator collation;
    private final long creatingThread;
    private Status status;

    public KeyIndex(boolean isRangeKey) {
        this.index = isRangeKey ? new TreeMap<AtomicMatchKey, Object>() : new HashMap<AtomicMatchKey, Object>(100);
        this.creatingThread = Thread.currentThread().getId();
        this.status = Status.UNDER_CONSTRUCTION;
    }

    public Map<AtomicMatchKey, Object> getUnderlyingMap() {
        return this.index;
    }

    public boolean isCreatedInThisThread() {
        return this.creatingThread == Thread.currentThread().getId();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void buildIndex(KeyDefinitionSet keySet, TreeInfo doc, XPathContext context) throws XPathException {
        List<KeyDefinition> definitions = keySet.getKeyDefinitions();
        for (int k = 0; k < definitions.size(); ++k) {
            this.constructIndex(doc, definitions.get(k), context, k == 0);
        }
        this.rules = context.getConfiguration().getConversionRules();
        this.implicitTimezone = context.getImplicitTimezone();
        this.collation = definitions.get(0).getCollation();
    }

    private void constructIndex(TreeInfo doc, KeyDefinition keydef, XPathContext context, boolean isFirst) throws XPathException {
        Pattern match = keydef.getMatch();
        XPathContextMajor xc = context.newContext();
        xc.setOrigin(keydef);
        xc.setCurrentComponent(keydef.getDeclaringComponent());
        xc.setTemporaryOutputState(169);
        SlotManager map = keydef.getStackFrameMap();
        if (map != null) {
            xc.openStackFrame(map);
        }
        SequenceTool.supply(match.selectNodes(doc, xc), node -> this.processNode((NodeInfo)node, keydef, xc, isFirst));
    }

    private void processNode(NodeInfo node, KeyDefinition keydef, XPathContext xc, boolean isFirst) throws XPathException {
        ManualIterator si = new ManualIterator(node);
        xc.setCurrentIterator(si);
        StringCollator collation = keydef.getCollation();
        int implicitTimezone = xc.getImplicitTimezone();
        PullEvaluator use = keydef.obtainUseEvaluator();
        SequenceIterator useval = use.iterate(xc);
        if (keydef.isComposite()) {
            ArrayList<AtomicMatchKey> amks = new ArrayList<AtomicMatchKey>(4);
            SequenceTool.supply(useval, keyVal -> amks.add(KeyIndex.getCollationKey((AtomicValue)keyVal, collation, implicitTimezone)));
            this.addEntry(new CompositeAtomicMatchKey(amks), node, isFirst);
        } else {
            AtomicValue keyVal2;
            while ((keyVal2 = (AtomicValue)useval.next()) != null) {
                if (keyVal2.isNaN()) continue;
                UType actualUType = keyVal2.getUType();
                if (!this.keyTypesPresent.subsumes(actualUType)) {
                    this.keyTypesPresent = this.keyTypesPresent.union(actualUType);
                }
                AtomicMatchKey amk = KeyIndex.getCollationKey(keyVal2, collation, implicitTimezone);
                if (actualUType.equals(UType.UNTYPED_ATOMIC) && keydef.isConvertUntypedToOther()) {
                    if (this.untypedKeys == null) {
                        this.untypedKeys = new ArrayList<StringValue>(20);
                    }
                    this.untypedKeys.add((StringValue)keyVal2);
                }
                this.addEntry(amk, node, isFirst);
            }
        }
    }

    private void addEntry(AtomicMatchKey val, NodeInfo curr, boolean isFirst) {
        Object value = this.index.get(val);
        if (value == null) {
            this.index.put(val, curr);
        } else {
            ArrayList<NodeInfo> nodes;
            if (value instanceof NodeInfo) {
                nodes = new ArrayList<NodeInfo>(4);
                nodes.add((NodeInfo)value);
                this.index.put(val, nodes);
            } else {
                nodes = (ArrayList<NodeInfo>)value;
            }
            if (isFirst) {
                if (nodes.get(nodes.size() - 1) != curr) {
                    nodes.add(curr);
                }
            } else {
                LocalOrderComparer comparer = LocalOrderComparer.getInstance();
                boolean found = false;
                for (int i2 = nodes.size() - 1; i2 >= 0; --i2) {
                    int d = comparer.compare(curr, (NodeInfo)nodes.get(i2));
                    if (d < 0) continue;
                    if (d != 0) {
                        nodes.add(i2 + 1, curr);
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    nodes.add(0, curr);
                }
            }
        }
    }

    public void reindexUntypedValues(BuiltInAtomicType type) throws XPathException {
        UType uType = type.getUType();
        if (UType.STRING_LIKE.subsumes(uType)) {
            return;
        }
        if (UType.NUMERIC.subsumes(uType)) {
            type = BuiltInAtomicType.DOUBLE;
        }
        StringConverter converter = type.getStringConverter(this.rules);
        for (StringValue v : this.untypedKeys) {
            AtomicMatchKey uk = KeyIndex.getCollationKey(v, this.collation, this.implicitTimezone);
            AtomicValue convertedValue = converter.convertString(v.getUnicodeStringValue()).asAtomic();
            AtomicMatchKey amk = KeyIndex.getCollationKey(convertedValue, this.collation, this.implicitTimezone);
            Object value = this.index.get(uk);
            if (value instanceof NodeInfo) {
                this.addEntry(amk, (NodeInfo)value, false);
                continue;
            }
            List nodes = (List)value;
            for (NodeInfo node : nodes) {
                this.addEntry(amk, node, false);
            }
        }
    }

    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    public SequenceIterator getNodes(AtomicValue soughtValue) throws XPathException {
        if (this.untypedKeys != null && !this.keyTypesConvertedFromUntyped.subsumes(soughtValue.getUType())) {
            this.reindexUntypedValues(soughtValue.getPrimitiveType());
        }
        if (soughtValue.isUntypedAtomic()) {
            ArrayList<NodeInfo> resultNodes = new ArrayList<NodeInfo>();
            int counter = 0;
            for (PrimitiveUType type : this.keyTypesPresent.decompose()) {
                AtomicType targetType = (AtomicType)type.toItemType();
                AtomicValue converted = Converter.convert(soughtValue, targetType, this.rules);
                Object value = this.index.get(KeyIndex.getCollationKey(converted, this.collation, this.implicitTimezone));
                if (value == null) continue;
                ++counter;
                if (value instanceof NodeInfo) {
                    resultNodes.add((NodeInfo)value);
                    continue;
                }
                resultNodes.addAll((List)value);
            }
            SequenceIterator result = new ListIterator.Of(resultNodes);
            if (counter > 1) {
                result = new DocumentOrderIterator(result, GlobalOrderComparer.getInstance());
            }
            return result;
        }
        Object value = this.index.get(KeyIndex.getCollationKey(soughtValue, this.collation, this.implicitTimezone));
        return this.entryIterator(value);
    }

    private SequenceIterator entryIterator(Object value) {
        if (value == null) {
            return EmptyIterator.ofNodes();
        }
        if (value instanceof NodeInfo) {
            return SingleNodeIterator.makeIterator((NodeInfo)value);
        }
        List nodes = (List)value;
        return new NodeListIterator(nodes);
    }

    public SequenceIterator getComposite(SequenceIterator soughtValue) throws XPathException {
        ArrayList<AtomicMatchKey> amks = new ArrayList<AtomicMatchKey>(4);
        SequenceTool.supply(soughtValue, keyVal -> amks.add(KeyIndex.getCollationKey((AtomicValue)keyVal, this.collation, this.implicitTimezone)));
        Object value = this.index.get(new CompositeAtomicMatchKey(amks));
        return this.entryIterator(value);
    }

    private static AtomicMatchKey getCollationKey(AtomicValue value, StringCollator collation, int implicitTimezone) throws XPathException {
        if (UType.STRING_LIKE.subsumes(value.getUType())) {
            if (collation == null) {
                return value.getUnicodeStringValue().tidy();
            }
            return collation.getCollationKey(value.getUnicodeStringValue());
        }
        return value.getXPathMatchKey(collation, implicitTimezone);
    }

    private class CompositeAtomicMatchKey
    implements AtomicMatchKey {
        private final List<AtomicMatchKey> keys;

        public CompositeAtomicMatchKey(List<AtomicMatchKey> keys) {
            this.keys = keys;
        }

        @Override
        public AtomicValue asAtomic() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompositeAtomicMatchKey && ((CompositeAtomicMatchKey)obj).keys.size() == this.keys.size()) {
                List<AtomicMatchKey> keys2 = ((CompositeAtomicMatchKey)obj).keys;
                for (int i2 = 0; i2 < this.keys.size(); ++i2) {
                    if (this.keys.get(i2).equals(keys2.get(i2))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int h = 447904982;
            for (AtomicMatchKey amk : this.keys) {
                h ^= amk.hashCode();
                h <<= 1;
            }
            return h;
        }
    }

    public static enum Status {
        UNDER_CONSTRUCTION,
        BUILT,
        FAILED;

    }
}

