/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.sf.saxon.Version;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class ProcInstParser {
    private static ConcurrentLinkedQueue<XMLReader> parserPool;

    private ProcInstParser() {
    }

    public static String getPseudoAttribute(String content, String name) throws XPathException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            AttributeProcessor filter2 = new AttributeProcessor(name, result);
            XMLReader reader = ProcInstParser.getXMLReader();
            reader.setContentHandler(filter2);
            StringReader in = new StringReader("<e " + content + "/>");
            reader.parse(new InputSource(in));
            parserPool.add(reader);
            return result.isEmpty() ? null : (String)result.get(0);
        }
        catch (IOException | SAXException e) {
            throw new XPathException("Invalid syntax for pseudo-attributes: '" + content + "'. ", "SXCH0005");
        }
    }

    private static XMLReader getXMLReader() {
        XMLReader parser;
        if (parserPool == null) {
            parserPool = new ConcurrentLinkedQueue();
        }
        if ((parser = parserPool.poll()) != null) {
            return parser;
        }
        return Version.platform.loadParser();
    }

    private static class AttributeProcessor
    extends XMLFilterImpl {
        List<String> result;
        String name;

        public AttributeProcessor(String name, List<String> result) {
            this.name = name;
            this.result = result;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String val = atts.getValue(this.name);
            if (val != null) {
                this.result.add(val);
            }
        }
    }
}

