/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public final class AnyURIValue
extends StringValue {
    public static final AnyURIValue EMPTY_URI = new AnyURIValue("");

    public AnyURIValue(UnicodeString value) {
        super(value == null ? EmptyUnicodeString.getInstance() : Whitespace.collapseWhitespace(value), (AtomicType)BuiltInAtomicType.ANY_URI);
    }

    public AnyURIValue(String value) {
        this(StringView.tidy(value));
    }

    public AnyURIValue(UnicodeString value, AtomicType type) {
        super(value == null ? "" : Whitespace.collapseWhitespace(value).toString(), type);
    }

    @Override
    public AnyURIValue copyAsSubType(AtomicType typeLabel) {
        return new AnyURIValue(this.getUnicodeStringValue(), typeLabel);
    }

    public StringValue convertToString() {
        return new StringValue(this.getContent(), (AtomicType)BuiltInAtomicType.STRING);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.ANY_URI;
    }

    public static String decode(String s) {
        if (s == null) {
            return null;
        }
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (s.indexOf(37) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = ByteBuffer.allocate(n);
        Charset utf8 = StandardCharsets.UTF_8;
        char c = s.charAt(0);
        boolean betweenBrackets = false;
        int i2 = 0;
        while (i2 < n) {
            assert (c == s.charAt(i2));
            if (c == '[') {
                betweenBrackets = true;
            } else if (betweenBrackets && c == ']') {
                betweenBrackets = false;
            }
            if (c != '%' || betweenBrackets) {
                sb.append(c);
                if (++i2 >= n) break;
                c = s.charAt(i2);
                continue;
            }
            bb.clear();
            do {
                assert (n - i2 >= 2);
                bb.put(AnyURIValue.hex(s.charAt(++i2), s.charAt(++i2)));
            } while (++i2 < n && (c = s.charAt(i2)) == '%');
            bb.flip();
            sb.append(utf8.decode(bb));
        }
        return sb.toString();
    }

    private static byte hex(char high, char low) {
        return (byte)(AnyURIValue.hexToDec(high) << 4 | AnyURIValue.hexToDec(low));
    }

    private static int hexToDec(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }
}

