/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Arrays;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.ContextFreeAtomicValue;
import net.sf.saxon.value.Whitespace;

public class HexBinaryValue
extends AtomicValue
implements AtomicMatchKey,
XPathComparable,
ContextFreeAtomicValue {
    private final byte[] binaryValue;

    public HexBinaryValue(UnicodeString in) throws XPathException {
        super(BuiltInAtomicType.HEX_BINARY);
        UnicodeString s = Whitespace.trim(in);
        int len32 = s.length32();
        if ((len32 & 1) != 0) {
            throw new XPathException("A hexBinary value must contain an even number of characters", "FORG0001");
        }
        this.binaryValue = new byte[len32 / 2];
        for (int i2 = 0; i2 < this.binaryValue.length; ++i2) {
            this.binaryValue[i2] = (byte)((this.fromHex(s.codePointAt(2 * i2)) << 4) + this.fromHex(s.codePointAt(2 * i2 + 1)));
        }
    }

    public HexBinaryValue(byte[] value) {
        super(BuiltInAtomicType.HEX_BINARY);
        this.binaryValue = value;
    }

    public HexBinaryValue(byte[] value, AtomicType typeLabel) {
        super(typeLabel);
        this.binaryValue = value;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        return new HexBinaryValue(this.binaryValue, typeLabel);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.HEX_BINARY;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    private int fromHex(int c) throws XPathException {
        int d;
        int n = d = c < 255 ? "0123456789ABCDEFabcdef".indexOf((char)c) : -1;
        if (d > 15) {
            d -= 6;
        }
        if (d < 0) {
            throw new XPathException("Invalid hexadecimal digit '" + c + "'", "FORG0001");
        }
        return d;
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        String digits = "0123456789ABCDEF";
        UnicodeBuilder sb = new UnicodeBuilder(this.binaryValue.length * 2);
        for (byte aBinaryValue : this.binaryValue) {
            sb.append(digits.charAt(aBinaryValue >> 4 & 0xF));
            sb.append(digits.charAt(aBinaryValue & 0xF));
        }
        return sb.toUnicodeString();
    }

    public int getLengthInOctets() {
        return this.binaryValue.length;
    }

    @Override
    public AtomicMatchKey getXPathMatchKey(StringCollator collator, int implicitTimezone) {
        return this;
    }

    @Override
    public XPathComparable getXPathComparable(StringCollator collator, int implicitTimezone) {
        return this;
    }

    @Override
    public XPathComparable getXPathComparable() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof HexBinaryValue && Arrays.equals(this.binaryValue, ((HexBinaryValue)other).binaryValue);
    }

    @Override
    public int hashCode() {
        return Base64BinaryValue.byteArrayHashCode(this.binaryValue);
    }

    @Override
    public int compareTo(XPathComparable o) {
        if (o instanceof Base64BinaryValue) {
            o = new HexBinaryValue(((Base64BinaryValue)o).getBinaryValue());
        }
        if (o instanceof HexBinaryValue) {
            byte[] other = ((HexBinaryValue)o).binaryValue;
            int len0 = this.binaryValue.length;
            int len1 = other.length;
            int shorter = Math.min(len0, len1);
            for (int i2 = 0; i2 < shorter; ++i2) {
                int a = this.binaryValue[i2] & 0xFF;
                int b = other[i2] & 0xFF;
                if (a == b) continue;
                return a < b ? -1 : 1;
            }
            return Integer.signum(len0 - len1);
        }
        throw new ClassCastException("Cannot compare xs:hexBinary to " + o.getClass());
    }
}

