/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;

public class IntHashMap<T> {
    private static final int NBIT = 30;
    private static final int NMAX = 0x40000000;
    private final double _factor;
    private int _nmax;
    private int _n;
    private int _nlo;
    private int _nhi;
    private int _shift;
    private int _mask;
    private int[] _key;
    private T[] _value;

    public IntHashMap() {
        this(8, 0.25);
    }

    public IntHashMap(int capacity) {
        this(capacity, 0.25);
    }

    public IntHashMap(int capacity, double factor) {
        this._factor = factor;
        this.setCapacity(capacity);
    }

    public void clear() {
        this._n = 0;
        for (int i2 = 0; i2 < this._nmax; ++i2) {
            this._value[i2] = this.nullValue();
        }
    }

    private T nullValue() {
        return null;
    }

    private boolean isNull(T value) {
        return value == null;
    }

    public T get(int key) {
        return this._value[this.indexOf(key)];
    }

    public int size() {
        return this._n;
    }

    public boolean remove(int key) {
        int i2 = this.indexOf(key);
        if (this._value[i2] == null) {
            return false;
        }
        --this._n;
        while (true) {
            int r;
            this._value[i2] = this.nullValue();
            int j = i2;
            do {
                if (!this.isNull(this._value[i2 = i2 - 1 & this._mask])) continue;
                return true;
            } while (i2 <= (r = this.hash(this._key[i2])) && r < j || r < j && j < i2 || j < i2 && i2 <= r);
            this._key[j] = this._key[i2];
            this._value[j] = this._value[i2];
        }
    }

    public T put(int key, T value) {
        if (this.isNull(value)) {
            throw new NullPointerException("IntHashMap does not allow null values");
        }
        int i2 = this.indexOf(key);
        T old = this._value[i2];
        if (!this.isNull(old)) {
            this._value[i2] = value;
        } else {
            this._key[i2] = key;
            this._value[i2] = value;
            this.grow();
        }
        return old;
    }

    private int hash(int key) {
        return 1327217885 * key >> this._shift & this._mask;
    }

    private int indexOf(int key) {
        int i2 = this.hash(key);
        while (!this.isNull(this._value[i2])) {
            if (this._key[i2] == key) {
                return i2;
            }
            i2 = i2 - 1 & this._mask;
        }
        return i2;
    }

    private void grow() {
        ++this._n;
        if (this._n > 0x40000000) {
            throw new RuntimeException("number of keys mapped exceeds 1073741824");
        }
        if (this._nlo < this._n && this._n <= this._nhi) {
            this.setCapacity(this._n);
        }
    }

    private void setCapacity(int capacity) {
        int nmax;
        if (capacity < this._n) {
            capacity = this._n;
        }
        double factor = this._factor < 0.01 ? 0.01 : (this._factor > 0.99 ? 0.99 : this._factor);
        int nbit = 1;
        for (nmax = 2; (double)nmax * factor < (double)capacity && nmax < 0x40000000; nmax *= 2) {
            ++nbit;
        }
        int nold = this._nmax;
        if (nmax == nold) {
            return;
        }
        this._nmax = nmax;
        this._nlo = (int)((double)nmax * factor);
        this._nhi = (int)(1.073741824E9 * factor);
        this._shift = 31 - nbit;
        this._mask = nmax - 1;
        int[] key = this._key;
        T[] value = this._value;
        this._n = 0;
        this._key = new int[nmax];
        this._value = this.makeValueArray(nmax);
        if (key != null) {
            for (int i2 = 0; i2 < nold; ++i2) {
                if (this.isNull(value[i2])) continue;
                this.put(key[i2], value[i2]);
            }
        }
    }

    private T[] makeValueArray(int size) {
        return new Object[size];
    }

    public IntIterator keyIterator() {
        return new IntHashMapKeyIterator(this);
    }

    public Iterator<T> valueIterator() {
        return new IntHashMapValueIterator(this);
    }

    public Iterable<T> valueSet() {
        return this::valueIterator;
    }

    public IntHashMap<T> copy() {
        IntHashMap<T> n = new IntHashMap<T>(this.size());
        IntIterator it = this.keyIterator();
        while (it.hasNext()) {
            int k = it.next();
            n.put(k, this.get(k));
        }
        return n;
    }

    public IntSet keySet() {
        return new IntHashMapKeySet(this);
    }

    private static class IntHashMapKeySet<U>
    extends IntSet {
        private final IntHashMap<U> map;

        public IntHashMapKeySet(IntHashMap<U> map) {
            this.map = map;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Immutable set");
        }

        @Override
        public IntSet copy() {
            IntHashSet s = new IntHashSet();
            IntIterator ii = this.iterator();
            while (ii.hasNext()) {
                s.add(ii.next());
            }
            return s;
        }

        @Override
        public IntSet mutableCopy() {
            return this.copy();
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public int size() {
            return ((IntHashMap)this.map)._n;
        }

        @Override
        public boolean isEmpty() {
            return ((IntHashMap)this.map)._n == 0;
        }

        @Override
        public boolean contains(int key) {
            return ((IntHashMap)this.map)._value[((IntHashMap)this.map).indexOf(key)] != null;
        }

        @Override
        public boolean remove(int value) {
            throw new UnsupportedOperationException("Immutable set");
        }

        @Override
        public boolean add(int value) {
            throw new UnsupportedOperationException("Immutable set");
        }

        @Override
        public IntIterator iterator() {
            return new IntHashMapKeyIterator<U>(this.map);
        }

        @Override
        public IntSet union(IntSet other) {
            return this.copy().union(other);
        }

        @Override
        public IntSet intersect(IntSet other) {
            return this.copy().intersect(other);
        }

        @Override
        public IntSet except(IntSet other) {
            return this.copy().except(other);
        }

        @Override
        public boolean containsAll(IntSet other) {
            return this.copy().containsAll(other);
        }

        public String toString() {
            return IntHashSet.stringify(this.iterator());
        }
    }

    private static class IntHashMapValueIterator<W>
    implements Iterator<W> {
        private int i = 0;
        private final IntHashMap<W> map;

        public IntHashMapValueIterator(IntHashMap<W> map) {
            this.map = map;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            while (this.i < ((IntHashMap)this.map)._key.length) {
                if (!((IntHashMap)this.map).isNull(((IntHashMap)this.map)._value[this.i])) {
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        @Override
        public W next() {
            Object temp = ((IntHashMap)this.map)._value[this.i++];
            if (((IntHashMap)this.map).isNull(temp)) {
                throw new NoSuchElementException();
            }
            return (W)temp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class IntHashMapKeyIterator<V>
    implements IntIterator {
        private int i = 0;
        private final IntHashMap<V> map;

        public IntHashMapKeyIterator(IntHashMap<V> map) {
            this.map = map;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            while (this.i < ((IntHashMap)this.map)._key.length) {
                if (!((IntHashMap)this.map).isNull(((IntHashMap)this.map)._value[this.i])) {
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        @Override
        public int next() {
            return ((IntHashMap)this.map)._key[this.i++];
        }
    }
}

