/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import net.sf.saxon.z.IntPredicateLambda;
import net.sf.saxon.z.IntPredicateProxy;
import net.sf.saxon.z.IntSet;

public class IntSetPredicate
implements IntPredicateProxy {
    private final IntSet set;
    public static final IntPredicateProxy ALWAYS_TRUE = IntPredicateLambda.of(i2 -> true);
    public static final IntPredicateProxy ALWAYS_FALSE = IntPredicateLambda.of(i2 -> false);

    public IntSetPredicate(IntSet set) {
        if (set == null) {
            throw new NullPointerException();
        }
        this.set = set;
    }

    @Override
    public boolean test(int value) {
        return this.set.contains(value);
    }

    public IntSet getIntSet() {
        return this.set;
    }

    public String toString() {
        return "in {" + this.set + "}";
    }
}

