/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;

public class NoSuchHeaderOrPropertyException
extends CamelExchangeException {
    private final String headerName;
    private final String propertyName;
    private final transient Class<?> type;

    public NoSuchHeaderOrPropertyException(Exchange exchange2, String headerName, String propertyName, Class<?> type) {
        super(String.format("No '%s' header or '%s' property available of type: %s (header: %s, property: %s)", headerName, propertyName, type.getName(), NoSuchHeaderOrPropertyException.header(exchange2, headerName), NoSuchHeaderOrPropertyException.property(exchange2, headerName)), exchange2);
        this.headerName = headerName;
        this.propertyName = propertyName;
        this.type = type;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getType() {
        return this.type;
    }

    protected static String header(Exchange exchange2, String headerName) {
        Object value = exchange2.getMessage().getHeader(headerName);
        return NoSuchHeaderOrPropertyException.valueDescription(value);
    }

    protected static String property(Exchange exchange2, String propertyName) {
        Object value = exchange2.getProperty(propertyName);
        return NoSuchHeaderOrPropertyException.valueDescription(value);
    }

    static String valueDescription(Object value) {
        if (value == null) {
            return "null";
        }
        return "has value: " + String.valueOf(value) + " of type: " + value.getClass().getCanonicalName();
    }
}

