/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Collection;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.TypeConversionException;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexibleAggregationStrategy<E>
implements AggregationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FlexibleAggregationStrategy.class);
    private Expression pickExpression = ExpressionBuilder.bodyExpression();
    private Predicate conditionPredicate;
    private Class<? extends Collection> collectionType;
    private Class<E> castAs = Object.class;
    private boolean storeNulls;
    private boolean ignoreInvalidCasts;
    private FlexibleAggregationStrategyInjector injector = new BodyInjector(this.castAs);
    private TimeoutAwareMixin timeoutMixin;
    private CompletionAwareMixin completionMixin;

    public FlexibleAggregationStrategy() {
    }

    public FlexibleAggregationStrategy(Class<E> type) {
        this.castAs = type;
    }

    public FlexibleAggregationStrategy<E> pick(Expression expression) {
        this.pickExpression = expression;
        return this;
    }

    public FlexibleAggregationStrategy<E> condition(Predicate predicate) {
        this.conditionPredicate = predicate;
        return this;
    }

    public FlexibleAggregationStrategy<E> accumulateInCollection(Class<? extends Collection> collectionType) {
        this.collectionType = collectionType;
        return this;
    }

    public FlexibleAggregationStrategy<E> storeInProperty(String propertyName) {
        this.injector = new PropertyInjector(this.castAs, propertyName);
        return this;
    }

    public FlexibleAggregationStrategy<E> storeInVariable(String variableName) {
        this.injector = new VariableInjector(this.castAs, variableName);
        return this;
    }

    public FlexibleAggregationStrategy<E> storeInHeader(String headerName) {
        this.injector = new HeaderInjector(this.castAs, headerName);
        return this;
    }

    public FlexibleAggregationStrategy<E> storeInBody() {
        this.injector = new BodyInjector(this.castAs);
        return this;
    }

    public FlexibleAggregationStrategy<E> castAs(Class<E> castAs) {
        this.castAs = castAs;
        this.injector.setType(castAs);
        return this;
    }

    public FlexibleAggregationStrategy<E> storeNulls() {
        this.storeNulls = true;
        return this;
    }

    public FlexibleAggregationStrategy<E> ignoreInvalidCasts() {
        this.ignoreInvalidCasts = true;
        return this;
    }

    public FlexibleAggregationStrategy<E> timeoutAware(TimeoutAwareMixin timeoutMixin) {
        this.timeoutMixin = timeoutMixin;
        return this;
    }

    public FlexibleAggregationStrategy<E> completionAware(CompletionAwareMixin completionMixin) {
        this.completionMixin = completionMixin;
        return this;
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        E picked;
        Exchange exchange2;
        block7: {
            exchange2 = oldExchange;
            if (exchange2 == null) {
                exchange2 = ExchangeHelper.createCorrelatedCopy(newExchange, true);
                this.injector.prepareAggregationExchange(exchange2);
            }
            if (this.conditionPredicate != null && !this.conditionPredicate.matches(newExchange)) {
                LOG.trace("Dropped exchange {} from aggregation as predicate {} was not matched", (Object)newExchange, (Object)this.conditionPredicate);
                return exchange2;
            }
            picked = null;
            try {
                picked = this.pickExpression.evaluate(newExchange, this.castAs);
            }
            catch (TypeConversionException exception) {
                if (this.ignoreInvalidCasts) break block7;
                throw exception;
            }
        }
        if (picked == null && !this.storeNulls) {
            LOG.trace("Dropped exchange {} from aggregation as pick expression returned null and storing nulls is not enabled", (Object)newExchange);
            return exchange2;
        }
        if (this.collectionType == null) {
            this.injectAsRawValue(exchange2, picked);
        } else {
            this.injectAsCollection(exchange2, picked, this.collectionType);
        }
        return exchange2;
    }

    @Override
    public void timeout(Exchange oldExchange, int index, int total, long timeout) {
        if (this.timeoutMixin == null) {
            return;
        }
        this.timeoutMixin.timeout(oldExchange, index, total, timeout);
    }

    @Override
    public void onCompletion(Exchange exchange2) {
        if (this.completionMixin == null) {
            return;
        }
        this.completionMixin.onCompletion(exchange2);
    }

    private void injectAsRawValue(Exchange oldExchange, E picked) {
        this.injector.setValue(oldExchange, picked);
    }

    private void injectAsCollection(Exchange oldExchange, E picked, Class<? extends Collection> collectionType) {
        Collection col = this.injector.getValueAsCollection(oldExchange, collectionType);
        col = this.safeInsertIntoCollection(oldExchange, col, picked);
        this.injector.setValueAsCollection(oldExchange, col);
    }

    private Collection<E> safeInsertIntoCollection(Exchange oldExchange, Collection<E> oldValue, E toInsert) {
        Collection collection;
        block6: {
            collection = null;
            try {
                if (oldValue == null || oldExchange.getProperty("CamelAggregatedCollectionGuard", Boolean.class) == null) {
                    try {
                        collection = this.collectionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        LOG.warn("Could not instantiate collection of type {}. Aborting aggregation.", this.collectionType);
                        throw CamelExecutionException.wrapCamelExecutionException(oldExchange, e);
                    }
                    oldExchange.setProperty("CamelAggregatedCollectionGuard", (Object)Boolean.FALSE);
                } else {
                    collection = this.collectionType.cast(oldValue);
                }
                collection.add(toInsert);
            }
            catch (ClassCastException exception) {
                if (this.ignoreInvalidCasts) break block6;
                throw exception;
            }
        }
        return collection;
    }

    private class BodyInjector
    extends FlexibleAggregationStrategyInjector {
        BodyInjector(Class<E> type) {
            super(type);
        }

        @Override
        public void prepareAggregationExchange(Exchange exchange2) {
            exchange2.getIn().setBody(null);
        }

        @Override
        public E getValue(Exchange exchange2) {
            return exchange2.getIn().getBody(this.type);
        }

        @Override
        public void setValue(Exchange exchange2, E obj) {
            exchange2.getIn().setBody(obj);
        }

        @Override
        public Collection<E> getValueAsCollection(Exchange exchange2, Class<? extends Collection> type) {
            Object value = exchange2.getIn().getBody();
            if (value == null) {
                return exchange2.getContext().getInjector().newInstance(type);
            }
            return exchange2.getIn().getBody(type);
        }

        @Override
        public void setValueAsCollection(Exchange exchange2, Collection<E> obj) {
            exchange2.getIn().setBody(obj);
        }
    }

    private abstract class FlexibleAggregationStrategyInjector {
        protected Class<E> type;

        FlexibleAggregationStrategyInjector(Class<E> type) {
            this.type = type;
        }

        public void setType(Class<E> type) {
            this.type = type;
        }

        public abstract void prepareAggregationExchange(Exchange var1);

        public abstract E getValue(Exchange var1);

        public abstract void setValue(Exchange var1, E var2);

        public abstract Collection<E> getValueAsCollection(Exchange var1, Class<? extends Collection> var2);

        public abstract void setValueAsCollection(Exchange var1, Collection<E> var2);
    }

    private class PropertyInjector
    extends FlexibleAggregationStrategyInjector {
        private final String propertyName;

        PropertyInjector(Class<E> type, String propertyName) {
            super(type);
            this.propertyName = propertyName;
        }

        @Override
        public void prepareAggregationExchange(Exchange exchange2) {
            exchange2.removeProperty(this.propertyName);
        }

        @Override
        public E getValue(Exchange exchange2) {
            return exchange2.getProperty(this.propertyName, this.type);
        }

        @Override
        public void setValue(Exchange exchange2, E obj) {
            exchange2.setProperty(this.propertyName, obj);
        }

        @Override
        public Collection<E> getValueAsCollection(Exchange exchange2, Class<? extends Collection> type) {
            Object value = exchange2.getProperty(this.propertyName);
            if (value == null) {
                return exchange2.getContext().getInjector().newInstance(type);
            }
            return exchange2.getProperty(this.propertyName, type);
        }

        @Override
        public void setValueAsCollection(Exchange exchange2, Collection<E> obj) {
            exchange2.setProperty(this.propertyName, obj);
        }
    }

    private class VariableInjector
    extends FlexibleAggregationStrategyInjector {
        private final String variableName;

        VariableInjector(Class<E> type, String variableName) {
            super(type);
            this.variableName = variableName;
        }

        @Override
        public void prepareAggregationExchange(Exchange exchange2) {
            exchange2.removeVariable(this.variableName);
        }

        @Override
        public E getValue(Exchange exchange2) {
            return exchange2.getVariable(this.variableName, this.type);
        }

        @Override
        public void setValue(Exchange exchange2, E obj) {
            exchange2.setVariable(this.variableName, obj);
        }

        @Override
        public Collection<E> getValueAsCollection(Exchange exchange2, Class<? extends Collection> type) {
            Object value = exchange2.getVariable(this.variableName);
            if (value == null) {
                return exchange2.getContext().getInjector().newInstance(type);
            }
            return exchange2.getVariable(this.variableName, type);
        }

        @Override
        public void setValueAsCollection(Exchange exchange2, Collection<E> obj) {
            exchange2.setVariable(this.variableName, obj);
        }
    }

    private class HeaderInjector
    extends FlexibleAggregationStrategyInjector {
        private final String headerName;

        HeaderInjector(Class<E> type, String headerName) {
            super(type);
            this.headerName = headerName;
        }

        @Override
        public void prepareAggregationExchange(Exchange exchange2) {
            exchange2.getIn().removeHeader(this.headerName);
        }

        @Override
        public E getValue(Exchange exchange2) {
            return exchange2.getIn().getHeader(this.headerName, this.type);
        }

        @Override
        public void setValue(Exchange exchange2, E obj) {
            exchange2.getIn().setHeader(this.headerName, obj);
        }

        @Override
        public Collection<E> getValueAsCollection(Exchange exchange2, Class<? extends Collection> type) {
            Object value = exchange2.getIn().getHeader(this.headerName);
            if (value == null) {
                return exchange2.getContext().getInjector().newInstance(type);
            }
            return exchange2.getIn().getHeader(this.headerName, type);
        }

        @Override
        public void setValueAsCollection(Exchange exchange2, Collection<E> obj) {
            exchange2.getIn().setHeader(this.headerName, obj);
        }
    }

    public static interface TimeoutAwareMixin {
        public void timeout(Exchange var1, int var2, int var3, long var4);
    }

    public static interface CompletionAwareMixin {
        public void onCompletion(Exchange var1);
    }
}

