/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import java.util.function.BiPredicate;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Predicate;

public class PredicateClause<T>
implements Predicate {
    private final T parent;
    private java.util.function.Predicate<Exchange> predicate;

    public PredicateClause(T parent) {
        this.parent = parent;
        this.predicate = null;
    }

    @Override
    public boolean matches(Exchange exchange2) {
        return this.predicate != null && this.predicate.test(exchange2);
    }

    public T exchange(java.util.function.Predicate<Exchange> predicate) {
        this.predicate = predicate;
        return this.parent;
    }

    public T message(java.util.function.Predicate<Message> predicate) {
        return this.exchange(e -> predicate.test(e.getIn()));
    }

    public T body(java.util.function.Predicate<Object> predicate) {
        return this.exchange(e -> predicate.test(e.getIn().getBody()));
    }

    public <B> T body(Class<B> type, java.util.function.Predicate<B> predicate) {
        return this.exchange(e -> predicate.test(e.getIn().getBody(type)));
    }

    public T body(BiPredicate<Object, Map<String, Object>> predicate) {
        return this.exchange(e -> predicate.test(e.getIn().getBody(), e.getIn().getHeaders()));
    }

    public <B> T body(Class<B> type, BiPredicate<B, Map<String, Object>> predicate) {
        return this.exchange(e -> predicate.test(e.getIn().getBody(type), e.getIn().getHeaders()));
    }
}

