/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;

public class ProcessClause<T>
implements Processor {
    private final T parent;
    private Processor processor;

    public ProcessClause(T parent) {
        this.parent = parent;
    }

    @Override
    public void process(Exchange exchange2) throws Exception {
        if (this.processor != null) {
            this.processor.process(exchange2);
        }
    }

    public T exchange(Consumer<Exchange> consumer) {
        this.processor = consumer::accept;
        return this.parent;
    }

    public T message(Consumer<Message> consumer) {
        this.processor = e -> consumer.accept(e.getIn());
        return this.parent;
    }

    public T body(Consumer<Object> consumer) {
        this.processor = e -> consumer.accept(e.getIn().getBody());
        return this.parent;
    }

    public <B> T body(Class<B> type, Consumer<B> consumer) {
        this.processor = e -> consumer.accept(e.getIn().getBody(type));
        return this.parent;
    }

    public T body(BiConsumer<Object, Map<String, Object>> consumer) {
        this.processor = e -> consumer.accept(e.getIn().getBody(), e.getIn().getHeaders());
        return this.parent;
    }

    public <B> T body(Class<B> type, BiConsumer<B, Map<String, Object>> consumer) {
        this.processor = e -> consumer.accept(e.getIn().getBody(type), e.getIn().getHeaders());
        return this.parent;
    }
}

