/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPMessage;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.attachment.DefaultAttachmentMessage;
import org.apache.camel.component.spring.ws.SpringWebserviceConfiguration;
import org.apache.camel.component.spring.ws.SpringWebserviceEndpoint;
import org.apache.camel.component.spring.ws.SpringWebserviceHelper;
import org.apache.camel.component.spring.ws.SpringWebserviceMessage;
import org.apache.camel.support.DefaultConsumer;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.mime.MimeMessage;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.saaj.SaajSoapMessage;

public class SpringWebserviceConsumer
extends DefaultConsumer
implements MessageEndpoint {
    private final SpringWebserviceEndpoint endpoint;
    private final SpringWebserviceConfiguration configuration;

    public SpringWebserviceConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = (SpringWebserviceEndpoint)endpoint;
        this.configuration = this.endpoint.getConfiguration();
    }

    @Override
    public boolean isHostedService() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(MessageContext messageContext) throws Exception {
        Exchange exchange2 = this.createExchange(false);
        try {
            Message responseMessage;
            this.populateExchangeFromMessageContext(messageContext, exchange2);
            if (Boolean.TRUE.equals(this.getEndpoint().getCamelContext().isUseBreadcrumb())) {
                this.populateExchangeWithBreadcrumbFromMessageContext(messageContext, exchange2);
            }
            this.getProcessor().process(exchange2);
            if (exchange2.getException() != null) {
                throw exchange2.getException();
            }
            if (exchange2.getPattern().isOutCapable() && (responseMessage = exchange2.getMessage(Message.class)) != null) {
                Source responseBody = responseMessage.getBody(Source.class);
                WebServiceMessage response = messageContext.getResponse();
                this.configuration.getMessageFilter().filterConsumer(exchange2, response);
                SpringWebserviceHelper.toResult(responseBody, response.getPayloadResult());
            }
        }
        finally {
            this.releaseExchange(exchange2, false);
        }
    }

    private void populateExchangeWithBreadcrumbFromMessageContext(MessageContext messageContext, Exchange exchange2) {
        WebServiceMessage webServiceMessage = messageContext.getRequest();
        if (webServiceMessage instanceof SaajSoapMessage) {
            SaajSoapMessage saajSoap = (SaajSoapMessage)webServiceMessage;
            this.populateExchangeWithBreadcrumbFromSaajMessage(exchange2, saajSoap);
        } else {
            this.populateExchangeWithBreadcrumbFromMessageContext(exchange2, messageContext);
        }
    }

    private void populateExchangeWithBreadcrumbFromSaajMessage(Exchange exchange2, SaajSoapMessage saajSoap) {
        String[] breadcrumbIdHeaderValues;
        MimeHeaders mimeHeaders;
        SOAPMessage soapMessageRequest;
        if (saajSoap != null && (soapMessageRequest = saajSoap.getSaajMessage()) != null && (mimeHeaders = soapMessageRequest.getMimeHeaders()) != null && (breadcrumbIdHeaderValues = mimeHeaders.getHeader("breadcrumbId")) != null && breadcrumbIdHeaderValues.length >= 1) {
            exchange2.getIn().setHeader("breadcrumbId", breadcrumbIdHeaderValues[0]);
        }
    }

    private void populateExchangeWithBreadcrumbFromMessageContext(Exchange exchange2, MessageContext messageContext) {
        HttpServletRequest obj;
        String breadcrumbId;
        if (messageContext != null && (breadcrumbId = (obj = (HttpServletRequest)messageContext.getProperty("transport.http.servletRequest")).getHeader("breadcrumbId")) != null) {
            exchange2.getIn().setHeader("breadcrumbId", breadcrumbId);
        }
    }

    private void populateExchangeFromMessageContext(MessageContext messageContext, Exchange exchange2) {
        this.populateExchangeWithPropertiesFromMessageContext(messageContext, exchange2);
        WebServiceMessage request = messageContext.getRequest();
        SpringWebserviceMessage swm = exchange2.getExchangeExtension().getInOrNull(SpringWebserviceMessage.class);
        if (swm == null) {
            swm = new SpringWebserviceMessage(exchange2.getContext(), request);
            exchange2.setIn(swm);
        } else {
            swm.setWebServiceMessage(request);
        }
        this.extractSourceFromSoapHeader(exchange2.getIn().getHeaders(), request);
        this.extractAttachmentsFromRequest(request, exchange2);
    }

    private void populateExchangeWithPropertiesFromMessageContext(MessageContext messageContext, Exchange exchange2) {
        String[] propertyNames = messageContext.getPropertyNames();
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                exchange2.setProperty(propertyName, messageContext.getProperty(propertyName));
            }
        }
    }

    private void extractSourceFromSoapHeader(Map<String, Object> headers, WebServiceMessage request) {
        SoapMessage soapMessage;
        SoapHeader soapHeader;
        if (request instanceof SoapMessage && (soapHeader = (soapMessage = (SoapMessage)request).getSoapHeader()) != null) {
            headers.put("CamelSpringWebserviceSoapHeader", soapHeader.getSource());
            Iterator<QName> attIter = soapHeader.getAllAttributes();
            while (attIter.hasNext()) {
                QName name = attIter.next();
                headers.put(name.getLocalPart(), soapHeader.getAttributeValue(name));
            }
            Iterator<SoapHeaderElement> elementIter = soapHeader.examineAllHeaderElements();
            while (elementIter.hasNext()) {
                SoapHeaderElement element = elementIter.next();
                QName name = element.getName();
                headers.put(name.getLocalPart(), element);
            }
        }
    }

    private void extractAttachmentsFromRequest(WebServiceMessage request, Exchange exchange2) {
        DefaultAttachmentMessage dam = null;
        if (request instanceof MimeMessage) {
            MimeMessage mimeMessage = (MimeMessage)request;
            Iterator<Attachment> attachmentsIterator = mimeMessage.getAttachments();
            while (attachmentsIterator.hasNext()) {
                Attachment attachment = attachmentsIterator.next();
                if (dam == null) {
                    dam = new DefaultAttachmentMessage(exchange2.getIn());
                }
                dam.addAttachment(attachment.getContentId(), attachment.getDataHandler());
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.configuration.getEndpointMapping() != null) {
            this.configuration.getEndpointMapping().removeConsumer(this.configuration.getEndpointMappingKey());
        }
        super.doStop();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.configuration.getEndpointMapping() != null) {
            this.configuration.getEndpointMapping().addConsumer(this.configuration.getEndpointMappingKey(), this);
        }
        super.doStart();
    }
}

