/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws.bean;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.transport.WebServiceConnection;

public class CamelDirectConnection
implements WebServiceConnection {
    private static final Logger LOG = LoggerFactory.getLogger(CamelDirectConnection.class);
    private CamelContext camelContext;
    private final URI destination;

    public CamelDirectConnection(CamelContext camelContext, URI uri) throws URISyntaxException {
        this.camelContext = camelContext;
        this.destination = new URI("direct:" + String.valueOf(uri) + "?block=false");
    }

    @Override
    public void send(WebServiceMessage message) throws IOException {
        try {
            this.camelContext.createProducerTemplate().sendBody(this.destination.toString(), (Object)message);
        }
        catch (CamelExecutionException e) {
            LOG.warn("Could not found any camel endpoint [{}] for wsa:ReplyTo camel mapping.", (Object)this.destination);
        }
    }

    @Override
    public WebServiceMessage receive(WebServiceMessageFactory messageFactory) throws IOException {
        return null;
    }

    @Override
    public URI getUri() throws URISyntaxException {
        return this.destination;
    }

    @Override
    public boolean hasError() throws IOException {
        return false;
    }

    @Override
    public String getErrorMessage() throws IOException {
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

