/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws.bean;

import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.spring.ws.bean.CamelSpringWSEndpointMapping;
import org.apache.camel.component.spring.ws.type.EndpointMappingKey;
import org.apache.camel.component.spring.ws.type.EndpointMappingType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointInvocationChain;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.server.endpoint.mapping.AbstractEndpointMapping;
import org.springframework.ws.server.endpoint.support.PayloadRootUtils;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.server.SoapEndpointInvocationChain;
import org.springframework.ws.soap.server.SoapEndpointMapping;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.xml.xpath.XPathExpression;
import org.w3c.dom.Node;

public class CamelEndpointMapping
extends AbstractEndpointMapping
implements InitializingBean,
CamelSpringWSEndpointMapping,
SoapEndpointMapping,
CamelContextAware {
    private static final String DOUBLE_QUOTE = "\"";
    private static final String URI_PATH_WILDCARD = "*";
    private final Map<EndpointMappingKey, MessageEndpoint> endpoints = new ConcurrentHashMap<EndpointMappingKey, MessageEndpoint>();
    private TransformerFactory transformerFactory;
    private CamelContext camelContext;
    private String[] actorsOrRoles;
    private boolean isUltimateReceiver = true;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    protected Object getEndpointInternal(MessageContext messageContext) throws Exception {
        for (Map.Entry<EndpointMappingKey, MessageEndpoint> endpointEntry : this.endpoints.entrySet()) {
            String messageKey;
            EndpointMappingKey key = endpointEntry.getKey();
            switch (key.getType()) {
                case ROOT_QNAME: {
                    messageKey = this.getRootQName(messageContext);
                    break;
                }
                case SOAP_ACTION: {
                    messageKey = this.getSoapAction(messageContext);
                    break;
                }
                case XPATHRESULT: {
                    messageKey = this.getXPathResult(messageContext, key.getExpression());
                    break;
                }
                case URI: {
                    messageKey = this.getUri();
                    break;
                }
                case URI_PATH: {
                    String lookupKey;
                    messageKey = this.getUriPath();
                    if (messageKey == null || !key.getLookupKey().endsWith(URI_PATH_WILDCARD) || !messageKey.startsWith(lookupKey = key.getLookupKey().substring(0, key.getLookupKey().length() - 1))) break;
                    return endpointEntry.getValue();
                }
                default: {
                    throw new RuntimeCamelException("Invalid mapping type specified. Supported types are: root QName, SOAP action, XPath expression and URI");
                }
            }
            if (!key.getLookupKey().equals(messageKey)) continue;
            return endpointEntry.getValue();
        }
        return null;
    }

    @Override
    protected final EndpointInvocationChain createEndpointInvocationChain(MessageContext messageContext, Object endpoint, EndpointInterceptor[] interceptors) {
        for (EndpointMappingKey key : this.endpoints.keySet()) {
            if (!EndpointMappingType.SOAP_ACTION.equals((Object)key.getType())) continue;
            String messageKey = this.getSoapAction(messageContext);
            if (!key.getLookupKey().equals(messageKey)) continue;
            return new SoapEndpointInvocationChain(endpoint, interceptors, this.actorsOrRoles, this.isUltimateReceiver);
        }
        return super.createEndpointInvocationChain(messageContext, endpoint, interceptors);
    }

    private String getSoapAction(MessageContext messageContext) {
        WebServiceMessage webServiceMessage = messageContext.getRequest();
        if (webServiceMessage instanceof SoapMessage) {
            SoapMessage request = (SoapMessage)webServiceMessage;
            String soapAction = request.getSoapAction();
            if (StringUtils.hasLength(soapAction) && soapAction.startsWith(DOUBLE_QUOTE) && soapAction.endsWith(DOUBLE_QUOTE)) {
                return soapAction.substring(1, soapAction.length() - 1);
            }
            return soapAction;
        }
        return null;
    }

    private String getUri() throws URISyntaxException {
        WebServiceConnection webServiceConnection = this.getWeServiceConnection();
        if (webServiceConnection != null) {
            return webServiceConnection.getUri().toString();
        }
        return null;
    }

    private String getUriPath() throws URISyntaxException {
        WebServiceConnection webServiceConnection = this.getWeServiceConnection();
        if (webServiceConnection != null) {
            return webServiceConnection.getUri().getPath();
        }
        return null;
    }

    private WebServiceConnection getWeServiceConnection() {
        WebServiceConnection webServiceConnection;
        TransportContext transportContext = TransportContextHolder.getTransportContext();
        if (transportContext != null && (webServiceConnection = transportContext.getConnection()) != null) {
            return webServiceConnection;
        }
        return null;
    }

    private String getRootQName(MessageContext messageContext) throws TransformerException {
        QName qName = PayloadRootUtils.getPayloadRootQName(messageContext.getRequest().getPayloadSource(), this.transformerFactory);
        return qName != null ? qName.toString() : null;
    }

    private String getXPathResult(MessageContext messageContext, XPathExpression expression) {
        Node domNode;
        if (expression != null && (domNode = this.camelContext.getTypeConverter().convertTo(Node.class, messageContext.getRequest().getPayloadSource())) != null) {
            return expression.evaluateAsString(domNode.getFirstChild());
        }
        return null;
    }

    @Override
    public void addConsumer(EndpointMappingKey key, MessageEndpoint endpoint) {
        this.endpoints.put(key, endpoint);
    }

    @Override
    public void removeConsumer(Object key) {
        this.endpoints.remove(key);
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.transformerFactory == null) {
            this.transformerFactory = TransformerFactory.newInstance();
            this.transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            try {
                this.transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                this.transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public final void setActorOrRole(String actorOrRole) {
        Assert.notNull((Object)actorOrRole, "actorOrRole must not be null");
        this.actorsOrRoles = new String[]{actorOrRole};
    }

    @Override
    public final void setActorsOrRoles(String[] actorsOrRoles) {
        Assert.notEmpty((Object[])actorsOrRoles, "actorsOrRoles must not be empty");
        this.actorsOrRoles = actorsOrRoles;
    }

    @Override
    public final void setUltimateReceiver(boolean ultimateReceiver) {
        this.isUltimateReceiver = ultimateReceiver;
    }
}

