/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.ByteArrayInputStreamCache;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.ReaderCache;
import org.apache.camel.util.IOHelper;

@Converter(generateBulkLoader=true)
public final class StreamCacheConverter {
    private StreamCacheConverter() {
    }

    @Converter(order=1)
    public static StreamCache convertToStreamCache(ByteArrayInputStream stream, Exchange exchange2) throws IOException {
        return new ByteArrayInputStreamCache(stream);
    }

    @Converter(order=2)
    public static StreamCache convertToStreamCache(InputStream stream, Exchange exchange2) throws IOException {
        CachedOutputStream cos = new CachedOutputStream(exchange2);
        IOHelper.copyAndCloseInput(stream, cos);
        return cos.newStreamCache();
    }

    @Converter(order=3)
    public static StreamCache convertToStreamCache(CachedOutputStream cos, Exchange exchange2) throws IOException {
        return cos.newStreamCache();
    }

    @Converter(order=4)
    public static StreamCache convertToStreamCache(Reader reader, Exchange exchange2) throws IOException {
        String data = exchange2.getContext().getTypeConverter().convertTo(String.class, exchange2, reader);
        return new ReaderCache(data);
    }

    @Converter(order=5)
    public static byte[] convertToByteArray(StreamCache cache, Exchange exchange2) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        cache.writeTo(os);
        return os.toByteArray();
    }

    @Converter(order=6)
    public static ByteBuffer convertToByteBuffer(StreamCache cache, Exchange exchange2) throws IOException {
        byte[] array = StreamCacheConverter.convertToByteArray(cache, exchange2);
        return ByteBuffer.wrap(array);
    }
}

