/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.support.TypeConverterSupport;

public class ArrayTypeConverter
extends TypeConverterSupport {
    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange2, Object value) {
        if (type.isArray()) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Object array = Array.newInstance(type.getComponentType(), collection.size());
                if (array instanceof Object[]) {
                    collection.toArray((Object[])array);
                } else {
                    int index = 0;
                    for (Object element : collection) {
                        Array.set(array, index++, element);
                    }
                }
                return (T)array;
            }
            if (value != null && value.getClass().isArray()) {
                int size = Array.getLength(value);
                Object answer = Array.newInstance(type.getComponentType(), size);
                for (int i2 = 0; i2 < size; ++i2) {
                    Array.set(answer, i2, Array.get(value, i2));
                }
                return (T)answer;
            }
        } else if (Collection.class.isAssignableFrom(type) && value != null) {
            if (value instanceof Object[]) {
                return (T)Arrays.asList((Object[])value);
            }
            if (value.getClass().isArray()) {
                int size = Array.getLength(value);
                ArrayList<Object> answer = new ArrayList<Object>(size);
                for (int i3 = 0; i3 < size; ++i3) {
                    answer.add(Array.get(value, i3));
                }
                return (T)answer;
            }
        }
        return null;
    }
}

