/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.util.concurrent.Future;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.TypeConverterSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FutureTypeConverter
extends TypeConverterSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FutureTypeConverter.class);
    private final TypeConverter converter;

    public FutureTypeConverter(TypeConverter converter) {
        this.converter = converter;
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange2, Object value) {
        try {
            return this.doConvertTo(type, exchange2, value);
        }
        catch (Exception e) {
            throw new TypeConversionException(value, type, e);
        }
    }

    private <T> T doConvertTo(Class<T> type, Exchange exchange2, Object value) throws Exception {
        if (StreamCache.class.isAssignableFrom(value.getClass())) {
            return null;
        }
        if (Future.class.isAssignableFrom(value.getClass())) {
            Future future = (Future)value;
            if (future.isCancelled()) {
                return (T)MISS_VALUE;
            }
            LOG.trace("Getting future response");
            Object body2 = future.get();
            LOG.trace("Got future response");
            if (body2 == null) {
                return (T)MISS_VALUE;
            }
            if (type.isAssignableFrom(body2.getClass())) {
                return type.cast(body2);
            }
            if (body2 instanceof Exchange) {
                Exchange result = (Exchange)body2;
                body2 = ExchangeHelper.extractResultBody(result, result.getPattern());
            }
            return this.converter.convertTo(type, exchange2, body2);
        }
        return null;
    }
}

