/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Comparator;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Ordered;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatCustomizer;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageCustomizer;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.LifecycleStrategySupport;

class CustomizersLifecycleStrategy
extends LifecycleStrategySupport {
    private final CamelContext camelContext;

    public CustomizersLifecycleStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void onComponentAdd(String name, Component component) {
        Registry registry = this.camelContext.getRegistry();
        if (registry == null) {
            return;
        }
        Set<ComponentCustomizer.Policy> filters = registry.findByType(ComponentCustomizer.Policy.class);
        if (filters.isEmpty() || filters.stream().allMatch(filter2 -> filter2.test(name, component))) {
            registry.findByType(ComponentCustomizer.class).stream().sorted(Comparator.comparingInt(Ordered::getOrder)).filter(customizer2 -> customizer2.isEnabled(name, component)).forEach(customizer2 -> customizer2.configure(name, component));
        }
    }

    @Override
    public void onDataFormatCreated(String name, DataFormat dataFormat) {
        Registry registry = this.camelContext.getRegistry();
        if (registry == null) {
            return;
        }
        Set<DataFormatCustomizer.Policy> filters = registry.findByType(DataFormatCustomizer.Policy.class);
        if (filters.isEmpty() || filters.stream().allMatch(filter2 -> filter2.test(name, dataFormat))) {
            registry.findByType(DataFormatCustomizer.class).stream().sorted(Comparator.comparingInt(Ordered::getOrder)).filter(customizer2 -> customizer2.isEnabled(name, dataFormat)).forEach(customizer2 -> customizer2.configure(name, dataFormat));
        }
    }

    @Override
    public void onLanguageCreated(String name, Language language) {
        Registry registry = this.camelContext.getRegistry();
        if (registry == null) {
            return;
        }
        Set<LanguageCustomizer.Policy> filters = registry.findByType(LanguageCustomizer.Policy.class);
        if (filters.isEmpty() || filters.stream().allMatch(filter2 -> filter2.test(name, language))) {
            registry.findByType(LanguageCustomizer.class).stream().sorted(Comparator.comparingInt(Ordered::getOrder)).filter(customizer2 -> customizer2.isEnabled(name, language)).forEach(customizer2 -> customizer2.configure(name, language));
        }
    }
}

