/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.BeanConfigInject;
import org.apache.camel.BeanInject;
import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.PropertyInject;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.engine.CamelPostProcessorHelper;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelBeanPostProcessorInjector;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCamelBeanPostProcessor
implements CamelBeanPostProcessor,
CamelContextAware {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultCamelBeanPostProcessor.class);
    protected final List<CamelBeanPostProcessorInjector> beanPostProcessorInjectors = new ArrayList<CamelBeanPostProcessorInjector>();
    protected CamelPostProcessorHelper camelPostProcessorHelper;
    protected CamelContext camelContext;
    protected boolean enabled = true;
    protected boolean unbindEnabled;

    public DefaultCamelBeanPostProcessor() {
    }

    public DefaultCamelBeanPostProcessor(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isUnbindEnabled() {
        return this.unbindEnabled;
    }

    @Override
    public void setUnbindEnabled(boolean unbindEnabled) {
        this.unbindEnabled = unbindEnabled;
    }

    @Override
    public void addCamelBeanPostProjectInjector(CamelBeanPostProcessorInjector injector) {
        this.beanPostProcessorInjectors.add(injector);
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws Exception {
        LOG.trace("Camel bean processing before initialization for bean: {}", (Object)beanName);
        if (!this.canPostProcessBean(bean2, beanName)) {
            return bean2;
        }
        if (bean2 instanceof CamelContextAware) {
            CamelContextAware contextAware = (CamelContextAware)bean2;
            if (this.canSetCamelContext(bean2, beanName)) {
                DeferredContextBinding deferredBinding = bean2.getClass().getAnnotation(DeferredContextBinding.class);
                CamelContext context = this.getOrLookupCamelContext();
                if (context == null && deferredBinding == null) {
                    LOG.warn("No CamelContext defined yet so cannot inject into bean: {}", (Object)beanName);
                } else if (context != null) {
                    contextAware.setCamelContext(context);
                }
            }
        }
        if (this.enabled) {
            this.injectCamelContextPass(bean2, beanName);
            this.injectFirstPass(bean2, beanName, type -> !DefaultCamelBeanPostProcessor.isComplexUserType(type));
            this.injectSecondPass(bean2, beanName, type -> DefaultCamelBeanPostProcessor.isComplexUserType(type));
        }
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws Exception {
        LOG.trace("Camel bean processing after initialization for bean: {}", (Object)beanName);
        if (!this.canPostProcessBean(bean2, beanName)) {
            return bean2;
        }
        if (bean2 instanceof DefaultEndpoint) {
            DefaultEndpoint defaultEndpoint = (DefaultEndpoint)bean2;
            defaultEndpoint.setEndpointUriIfNotSpecified(beanName);
        }
        return bean2;
    }

    public CamelContext getOrLookupCamelContext() {
        return this.camelContext;
    }

    public CamelPostProcessorHelper getPostProcessorHelper() {
        if (this.camelPostProcessorHelper == null) {
            this.camelPostProcessorHelper = new CamelPostProcessorHelper(this.getOrLookupCamelContext());
        }
        return this.camelPostProcessorHelper;
    }

    protected boolean canPostProcessBean(Object bean2, String beanName) {
        if ("properties".equals(beanName)) {
            return false;
        }
        return bean2 != null;
    }

    protected boolean bindToRegistrySupported() {
        return true;
    }

    protected boolean canSetCamelContext(Object bean2, String beanName) {
        CamelContextAware camelContextAware;
        CamelContext context;
        if (bean2 instanceof CamelContextAware && (context = (camelContextAware = (CamelContextAware)bean2).getCamelContext()) != null) {
            LOG.trace("CamelContext already set on bean with id [{}]. Will keep existing CamelContext on bean.", (Object)beanName);
            return false;
        }
        return true;
    }

    protected void injectCamelContextPass(Object bean2, String beanName) {
        this.injectFields(bean2, beanName, type -> type.isAssignableFrom(CamelContext.class));
    }

    protected void injectFirstPass(Object bean2, String beanName, Function<Class<?>, Boolean> filter2) {
        this.injectFields(bean2, beanName, filter2);
        this.injectMethods(bean2, beanName, filter2);
        if (this.bindToRegistrySupported()) {
            this.injectClass(bean2, beanName);
            this.injectNestedClasses(bean2, beanName);
            this.injectBindToRegistryFields(bean2, beanName, filter2);
            this.injectBindToRegistryMethods(bean2, beanName, filter2);
        }
        this.injectEndpointFields(bean2, beanName, filter2);
    }

    protected void injectSecondPass(Object bean2, String beanName, Function<Class<?>, Boolean> filter2) {
        this.injectFields(bean2, beanName, filter2);
        if (this.bindToRegistrySupported()) {
            this.injectClass(bean2, beanName);
            this.injectNestedClasses(bean2, beanName);
            this.injectBindToRegistryFields(bean2, beanName, filter2);
            this.injectBindToRegistryMethods(bean2, beanName, filter2);
        }
        this.injectMethods(bean2, beanName, filter2);
        this.injectEndpointFields(bean2, beanName, filter2);
    }

    protected void injectEndpointFields(Object bean2, String beanName, Function<Class<?>, Boolean> accept) {
        ReflectionHelper.doWithFields(bean2.getClass(), field -> {
            Produce produce;
            if (accept != null && !((Boolean)accept.apply(field.getType())).booleanValue()) {
                return;
            }
            EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
            if (endpointInject != null) {
                this.injectField(field, endpointInject.value(), endpointInject.property(), bean2, beanName);
            }
            if ((produce = field.getAnnotation(Produce.class)) != null) {
                this.injectField(field, produce.value(), produce.property(), bean2, beanName, produce.binding());
            }
        });
    }

    protected void injectFields(Object bean2, String beanName, Function<Class<?>, Boolean> accept) {
        ReflectionHelper.doWithFields(bean2.getClass(), field -> {
            BeanConfigInject beanConfigInject;
            BeanInject beanInject;
            if (accept != null && !((Boolean)accept.apply(field.getType())).booleanValue()) {
                return;
            }
            PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
            if (propertyInject != null) {
                this.injectFieldProperty(field, propertyInject.value(), propertyInject.defaultValue(), propertyInject.separator(), bean2);
            }
            if ((beanInject = field.getAnnotation(BeanInject.class)) != null) {
                this.injectFieldBean(field, beanInject.value(), bean2, beanName);
            }
            if ((beanConfigInject = field.getAnnotation(BeanConfigInject.class)) != null) {
                this.injectFieldBeanConfig(field, beanConfigInject.value(), bean2, beanName);
            }
            for (CamelBeanPostProcessorInjector injector : this.beanPostProcessorInjectors) {
                injector.onFieldInject(field, bean2, beanName);
            }
        });
    }

    protected void injectBindToRegistryFields(Object bean2, String beanName, Function<Class<?>, Boolean> accept) {
        ReflectionHelper.doWithFields(bean2.getClass(), field -> {
            if (accept != null && !((Boolean)accept.apply(field.getType())).booleanValue()) {
                return;
            }
            BindToRegistry bind = field.getAnnotation(BindToRegistry.class);
            if (bind != null) {
                this.bindToRegistry(field, bind.value(), bean2, beanName, bind.beanPostProcess(), false, bind.initMethod(), bind.destroyMethod());
            }
        });
    }

    public void injectField(Field field, String endpointUri, String endpointProperty, Object bean2, String beanName) {
        this.injectField(field, endpointUri, endpointProperty, bean2, beanName, true);
    }

    public void injectField(Field field, String endpointUri, String endpointProperty, Object bean2, String beanName, boolean binding) {
        ReflectionHelper.setField(field, bean2, this.getPostProcessorHelper().getInjectionValue(field.getType(), endpointUri, endpointProperty, field.getName(), bean2, beanName, binding));
    }

    public void injectFieldBean(Field field, String name, Object bean2, String beanName) {
        ReflectionHelper.setField(field, bean2, this.getPostProcessorHelper().getInjectionBeanValue(field.getType(), name));
    }

    public void injectFieldBeanConfig(Field field, String name, Object bean2, String beanName) {
        ReflectionHelper.setField(field, bean2, this.getPostProcessorHelper().getInjectionBeanConfigValue(field.getType(), name));
    }

    public void injectFieldProperty(Field field, String propertyName, String propertyDefaultValue, String propertySeparator, Object bean2) {
        ReflectionHelper.setField(field, bean2, this.getPostProcessorHelper().getInjectionPropertyValue(field.getType(), field.getGenericType(), propertyName, propertyDefaultValue, propertySeparator));
    }

    protected void injectMethods(Object bean2, String beanName, Function<Class<?>, Boolean> accept) {
        ReflectionHelper.doWithMethods(bean2.getClass(), method -> {
            if (accept != null && !((Boolean)accept.apply(method.getReturnType())).booleanValue()) {
                return;
            }
            this.setterInjection(method, bean2, beanName);
            this.getPostProcessorHelper().consumerInjection(method, bean2, beanName);
            for (CamelBeanPostProcessorInjector injector : this.beanPostProcessorInjectors) {
                injector.onMethodInject(method, bean2, beanName);
            }
        });
    }

    protected void injectBindToRegistryMethods(Object bean2, String beanName, Function<Class<?>, Boolean> accept) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ReflectionHelper.doWithMethods(bean2.getClass(), method -> {
            if (accept != null && !((Boolean)accept.apply(method.getReturnType())).booleanValue()) {
                return;
            }
            BindToRegistry bind = method.getAnnotation(BindToRegistry.class);
            if (bind != null) {
                methods.add(method);
            }
        });
        methods.sort(Comparator.comparingInt(Method::getParameterCount));
        methods.sort((m1, m2) -> {
            Class<?>[] types1 = m1.getParameterTypes();
            Class<?>[] types2 = m2.getParameterTypes();
            if (types1.length == 0 && types2.length == 0) {
                return 0;
            }
            if (types1.length == 0) {
                return -1;
            }
            if (types2.length == 0) {
                return 1;
            }
            boolean usedByOthers1 = false;
            for (Class<?> clazz : types1) {
                usedByOthers1 |= methods.stream().anyMatch(m -> m.getParameterCount() > 0 && clazz.isAssignableFrom(m.getReturnType()));
            }
            boolean usedByOthers2 = false;
            for (Class<?> clazz : types2) {
                usedByOthers2 |= methods.stream().anyMatch(m -> m.getParameterCount() > 0 && clazz.isAssignableFrom(m.getReturnType()));
            }
            return Boolean.compare(usedByOthers1, usedByOthers2);
        });
        LOG.trace("Discovered {} @BindToRegistry methods", (Object)methods.size());
        methods.forEach(method -> {
            BindToRegistry bind = method.getAnnotation(BindToRegistry.class);
            this.bindToRegistry((Method)method, bind.value(), bean2, beanName, bind.beanPostProcess(), bind.lazy(), bind.initMethod(), bind.destroyMethod());
        });
    }

    protected void injectClass(Object bean2, String beanName) {
        Class<?> clazz = bean2.getClass();
        BindToRegistry ann = clazz.getAnnotation(BindToRegistry.class);
        if (ann != null) {
            this.bindToRegistry(clazz, ann.value(), bean2, beanName, ann.beanPostProcess(), ann.lazy(), ann.initMethod(), ann.destroyMethod());
        }
    }

    protected void injectNestedClasses(Object bean2, String beanName) {
        ReflectionHelper.doWithClasses(bean2.getClass(), clazz -> {
            BindToRegistry ann = clazz.getAnnotation(BindToRegistry.class);
            if (ann != null) {
                this.bindToRegistry(clazz, ann.value(), null, null, ann.beanPostProcess(), ann.lazy(), ann.initMethod(), ann.destroyMethod());
            }
        });
    }

    protected void setterInjection(Method method, Object bean2, String beanName) {
        Produce produce;
        EndpointInject endpointInject;
        BeanConfigInject beanConfigInject;
        BeanInject beanInject;
        PropertyInject propertyInject = method.getAnnotation(PropertyInject.class);
        if (propertyInject != null) {
            this.setterPropertyInjection(method, propertyInject.value(), propertyInject.defaultValue(), propertyInject.separator(), bean2);
        }
        if ((beanInject = method.getAnnotation(BeanInject.class)) != null) {
            this.setterBeanInjection(method, beanInject.value(), bean2, beanName);
        }
        if ((beanConfigInject = method.getAnnotation(BeanConfigInject.class)) != null) {
            this.setterBeanConfigInjection(method, beanConfigInject.value(), bean2, beanName);
        }
        if ((endpointInject = method.getAnnotation(EndpointInject.class)) != null) {
            this.setterInjection(method, bean2, beanName, endpointInject.value(), endpointInject.property());
        }
        if ((produce = method.getAnnotation(Produce.class)) != null) {
            this.setterInjection(method, bean2, beanName, produce.value(), produce.property());
        }
    }

    public void setterInjection(Method method, Object bean2, String beanName, String endpointUri, String endpointProperty) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
        } else {
            String propertyName = ObjectHelper.getPropertyName(method);
            Object value = this.getPostProcessorHelper().getInjectionValue(parameterTypes[0], endpointUri, endpointProperty, propertyName, bean2, beanName);
            org.apache.camel.support.ObjectHelper.invokeMethod(method, bean2, value);
        }
    }

    public void setterPropertyInjection(Method method, String propertyValue, String propertyDefaultValue, String propertySeparator, Object bean2) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
        } else {
            String propertyName = ObjectHelper.getPropertyName(method);
            Class<?> type = parameterTypes[0];
            Type genericType = method.getGenericParameterTypes()[0];
            Object value = this.getPostProcessorHelper().getInjectionPropertyValue(type, genericType, propertyValue, propertyDefaultValue, propertySeparator);
            org.apache.camel.support.ObjectHelper.invokeMethod(method, bean2, value);
        }
    }

    public void setterBeanInjection(Method method, String name, Object bean2, String beanName) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
        } else {
            Object value = this.getPostProcessorHelper().getInjectionBeanValue(parameterTypes[0], name);
            org.apache.camel.support.ObjectHelper.invokeMethod(method, bean2, value);
        }
    }

    public void setterBeanConfigInjection(Method method, String name, Object bean2, String beanName) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
        } else {
            Object value = this.getPostProcessorHelper().getInjectionBeanConfigValue(parameterTypes[0], name);
            org.apache.camel.support.ObjectHelper.invokeMethod(method, bean2, value);
        }
    }

    private void bindToRegistry(Class<?> clazz, String name, Object bean2, String beanName, boolean beanPostProcess, boolean lazy, String initMethod, String destroyMethod) {
        if (ObjectHelper.isEmpty(name)) {
            name = clazz.getSimpleName();
        }
        boolean postProcess = beanPostProcess;
        if (bean2 == null) {
            if (lazy) {
                postProcess = false;
                bean2 = () -> {
                    Object answer = this.getOrLookupCamelContext().getInjector().newInstance(clazz);
                    if (answer != null && beanPostProcess) {
                        try {
                            CamelBeanPostProcessor beanPostProcessor = PluginHelper.getBeanPostProcessor(this.camelContext);
                            beanPostProcessor.postProcessBeforeInitialization(answer, beanName);
                            beanPostProcessor.postProcessAfterInitialization(answer, beanName);
                        }
                        catch (Exception e) {
                            throw RuntimeCamelException.wrapRuntimeException(e);
                        }
                    }
                    return answer;
                };
            } else {
                bean2 = this.getOrLookupCamelContext().getInjector().newInstance(clazz);
            }
        }
        if (this.unbindEnabled) {
            this.getOrLookupCamelContext().getRegistry().unbind(name);
        }
        if (ObjectHelper.isEmpty(initMethod)) {
            initMethod = CamelPostProcessorHelper.initMethodCandidate(bean2);
        }
        if (ObjectHelper.isEmpty(destroyMethod)) {
            destroyMethod = CamelPostProcessorHelper.destroyMethodCandidate(bean2);
        }
        Runnable task = PluginHelper.getDependencyInjectionAnnotationFactory(this.getOrLookupCamelContext()).createBindToRegistryFactory(name, bean2, clazz, beanName, postProcess, initMethod, destroyMethod);
        task.run();
    }

    private void bindToRegistry(Field field, String name, Object bean2, String beanName, boolean beanPostProcess, boolean lazy, String initMethod, String destroyMethod) {
        Supplier<Object> value;
        if (ObjectHelper.isEmpty(name)) {
            name = field.getName();
        }
        boolean postProcess = beanPostProcess;
        if (lazy) {
            postProcess = false;
            value = () -> {
                Object answer = ReflectionHelper.getField(field, bean2);
                if (answer != null && beanPostProcess) {
                    try {
                        CamelBeanPostProcessor beanPostProcessor = PluginHelper.getBeanPostProcessor(this.camelContext);
                        beanPostProcessor.postProcessBeforeInitialization(answer, beanName);
                        beanPostProcessor.postProcessAfterInitialization(answer, beanName);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeException(e);
                    }
                }
                return answer;
            };
        } else {
            value = ReflectionHelper.getField(field, bean2);
        }
        if (value != null) {
            if (ObjectHelper.isEmpty(initMethod)) {
                initMethod = CamelPostProcessorHelper.initMethodCandidate(bean2);
            }
            if (ObjectHelper.isEmpty(destroyMethod)) {
                destroyMethod = CamelPostProcessorHelper.destroyMethodCandidate(bean2);
            }
            if (this.unbindEnabled) {
                this.getOrLookupCamelContext().getRegistry().unbind(name);
            }
            Runnable task = PluginHelper.getDependencyInjectionAnnotationFactory(this.getOrLookupCamelContext()).createBindToRegistryFactory(name, value, field.getType(), beanName, postProcess, initMethod, destroyMethod);
            task.run();
        }
    }

    private void bindToRegistry(Method method, String name, Object bean2, String beanName, boolean beanPostProcess, boolean lazy, String initMethod, String destroyMethod) {
        Object value;
        if (ObjectHelper.isEmpty(name)) {
            name = method.getName();
        }
        boolean postProcess = beanPostProcess;
        if (lazy) {
            postProcess = false;
            value = () -> {
                Object answer = this.getPostProcessorHelper().getInjectionBeanMethodValue(this.getOrLookupCamelContext(), method, bean2, beanName, "BindToRegistry");
                if (answer != null && beanPostProcess) {
                    try {
                        CamelBeanPostProcessor beanPostProcessor = PluginHelper.getBeanPostProcessor(this.camelContext);
                        beanPostProcessor.postProcessBeforeInitialization(answer, beanName);
                        beanPostProcessor.postProcessAfterInitialization(answer, beanName);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeException(e);
                    }
                }
                return answer;
            };
        } else {
            value = this.getPostProcessorHelper().getInjectionBeanMethodValue(this.getOrLookupCamelContext(), method, bean2, beanName, "BindToRegistry");
        }
        if (value != null) {
            if (this.unbindEnabled) {
                this.getOrLookupCamelContext().getRegistry().unbind(name);
            }
            Runnable task = PluginHelper.getDependencyInjectionAnnotationFactory(this.getOrLookupCamelContext()).createBindToRegistryFactory(name, value, method.getReturnType(), beanName, postProcess, initMethod, destroyMethod);
            task.run();
        }
    }

    private static boolean isComplexUserType(Class<?> type) {
        return type != null && !type.isPrimitive() && !type.getName().startsWith("java.");
    }
}

