/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.PooledExchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.StreamCache;
import org.apache.camel.impl.engine.StreamCachingHelper;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationVetoable;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.UnitOfWorkHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnitOfWork
implements UnitOfWork {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUnitOfWork.class);
    final InflightRepository inflightRepository;
    final StreamCachingStrategy streamCachingStrategy;
    final boolean allowUseOriginalMessage;
    final boolean useBreadcrumb;
    private final CamelContext context;
    private final Deque<Route> routes = new ArrayDeque<Route>(8);
    private final Lock lock = new ReentrantLock();
    private final Logger log;
    private Exchange exchange;
    private List<Synchronization> synchronizations;
    private Message originalInMessage;
    private Set<Object> transactedBy;

    public DefaultUnitOfWork(Exchange exchange2) {
        this(exchange2, exchange2.getContext().getInflightRepository(), exchange2.getContext().isAllowUseOriginalMessage(), exchange2.getContext().isUseBreadcrumb());
    }

    protected DefaultUnitOfWork(Exchange exchange2, Logger logger, InflightRepository inflightRepository, boolean allowUseOriginalMessage, boolean useBreadcrumb) {
        this.allowUseOriginalMessage = allowUseOriginalMessage;
        this.useBreadcrumb = useBreadcrumb;
        this.context = exchange2.getContext();
        this.inflightRepository = inflightRepository;
        this.streamCachingStrategy = exchange2.getContext().getStreamCachingStrategy();
        this.log = logger;
        this.doOnPrepare(exchange2);
    }

    public DefaultUnitOfWork(Exchange exchange2, InflightRepository inflightRepository, boolean allowUseOriginalMessage, boolean useBreadcrumb) {
        this(exchange2, LOG, inflightRepository, allowUseOriginalMessage, useBreadcrumb);
    }

    UnitOfWork newInstance(Exchange exchange2) {
        return new DefaultUnitOfWork(exchange2, this.inflightRepository, this.allowUseOriginalMessage, this.useBreadcrumb);
    }

    @Override
    public boolean onPrepare(Exchange exchange2) {
        if (this.exchange == null) {
            this.doOnPrepare(exchange2);
            return true;
        }
        return false;
    }

    private boolean isStreamCacheInUse(Exchange exchange2) {
        Route route;
        String rid;
        boolean inUse = this.streamCachingStrategy.isEnabled();
        if (inUse && (rid = exchange2.getFromRouteId()) != null && (route = exchange2.getContext().getRoute(rid)) != null) {
            inUse = route.isStreamCaching() != null && route.isStreamCaching() != false;
        }
        return inUse;
    }

    private void doOnPrepare(Exchange exchange2) {
        String breadcrumbId;
        this.exchange = exchange2;
        if (this.allowUseOriginalMessage) {
            StreamCache cache;
            this.originalInMessage = exchange2.getIn().copy();
            if (this.isStreamCacheInUse(exchange2) && (cache = StreamCachingHelper.convertToStreamCache(this.streamCachingStrategy, exchange2, this.originalInMessage)) != null) {
                this.originalInMessage.setBody(cache);
                this.exchange.getIn().setBody(cache);
            }
        }
        if (this.useBreadcrumb && (breadcrumbId = exchange2.getIn().getHeader("breadcrumbId", String.class)) == null) {
            breadcrumbId = exchange2.getExchangeId();
            exchange2.getIn().setHeader("breadcrumbId", breadcrumbId);
        }
        if (this.context.getCamelContextExtension().isEventNotificationApplicable()) {
            try {
                EventHelper.notifyExchangeCreated(this.context, exchange2);
            }
            catch (Exception e) {
                this.log.warn("Exception occurred during event notification. This exception will be ignored.", (Throwable)e);
            }
        }
        this.inflightRepository.add(exchange2);
    }

    @Override
    public void reset() {
        this.exchange = null;
        this.routes.clear();
        if (this.synchronizations != null) {
            this.synchronizations.clear();
        }
        this.originalInMessage = null;
        if (this.transactedBy != null) {
            this.transactedBy.clear();
        }
    }

    @Override
    public void setParentUnitOfWork(UnitOfWork parentUnitOfWork) {
    }

    @Override
    public UnitOfWork createChildUnitOfWork(Exchange childExchange) {
        UnitOfWork answer = this.newInstance(childExchange);
        answer.setParentUnitOfWork(this);
        return answer;
    }

    @Override
    public void addSynchronization(Synchronization synchronization) {
        this.lock.lock();
        try {
            if (this.synchronizations == null) {
                this.synchronizations = new ArrayList<Synchronization>(8);
            }
            this.log.trace("Adding synchronization {}", (Object)synchronization);
            this.synchronizations.add(synchronization);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeSynchronization(Synchronization synchronization) {
        this.lock.lock();
        try {
            if (this.synchronizations != null) {
                this.synchronizations.remove(synchronization);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsSynchronization(Synchronization synchronization) {
        this.lock.lock();
        try {
            boolean bl = this.synchronizations != null && this.synchronizations.contains(synchronization);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void handoverSynchronization(Exchange target) {
        this.handoverSynchronization(target, null);
    }

    @Override
    public void handoverSynchronization(Exchange target, Predicate<Synchronization> filter2) {
        if (this.synchronizations == null || this.synchronizations.isEmpty()) {
            return;
        }
        Iterator<Synchronization> it = this.synchronizations.iterator();
        while (it.hasNext()) {
            Synchronization synchronization = it.next();
            boolean handover = true;
            SynchronizationVetoable veto = null;
            if (synchronization instanceof SynchronizationVetoable) {
                SynchronizationVetoable v;
                veto = v = (SynchronizationVetoable)synchronization;
                handover = veto.allowHandover();
            }
            if (handover && (filter2 == null || filter2.test(synchronization))) {
                this.log.trace("Handover synchronization {} to: {}", (Object)synchronization, (Object)target);
                target.getExchangeExtension().addOnCompletion(synchronization);
                if (veto != null) {
                    veto.beforeHandover(target);
                }
                it.remove();
                continue;
            }
            this.log.trace("Handover not allow for synchronization {}", (Object)synchronization);
        }
    }

    @Override
    public void done(Exchange exchange2) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork done for ExchangeId: {}", (Object)exchange2.getExchangeId());
        }
        UnitOfWorkHelper.doneSynchronizations(exchange2, this.synchronizations);
        this.inflightRepository.remove(exchange2);
        if (this.context.getCamelContextExtension().isEventNotificationApplicable()) {
            try {
                boolean failed = exchange2.isFailed();
                if (failed) {
                    EventHelper.notifyExchangeFailed(exchange2.getContext(), exchange2);
                } else {
                    EventHelper.notifyExchangeDone(exchange2.getContext(), exchange2);
                }
            }
            catch (Exception e) {
                this.log.warn("Exception occurred during event notification. This exception will be ignored.", (Throwable)e);
            }
        }
        if (exchange2 instanceof PooledExchange) {
            PooledExchange pooled = (PooledExchange)exchange2;
            try {
                if (pooled.isAutoRelease()) {
                    pooled.done();
                }
            }
            catch (Exception e) {
                this.log.warn("Exception occurred during exchange done. This exception will be ignored.", (Throwable)e);
            }
        } else {
            this.onDone();
        }
    }

    protected void onDone() {
        this.exchange.getExchangeExtension().setUnitOfWork(null);
    }

    @Override
    public void beforeRoute(Exchange exchange2, Route route) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork beforeRoute: {} for ExchangeId: {} with {}", new Object[]{route.getId(), exchange2.getExchangeId(), exchange2});
        }
        if (this.synchronizations != null && !this.synchronizations.isEmpty()) {
            UnitOfWorkHelper.beforeRouteSynchronizations(route, exchange2, this.synchronizations, this.log);
        }
    }

    @Override
    public void afterRoute(Exchange exchange2, Route route) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork afterRoute: {} for ExchangeId: {} with {}", new Object[]{route.getId(), exchange2.getExchangeId(), exchange2});
        }
        if (this.synchronizations != null && !this.synchronizations.isEmpty()) {
            UnitOfWorkHelper.afterRouteSynchronizations(route, exchange2, this.synchronizations, this.log);
        }
    }

    @Override
    public Message getOriginalInMessage() {
        if (this.originalInMessage == null && !this.context.isAllowUseOriginalMessage().booleanValue()) {
            throw new IllegalStateException("AllowUseOriginalMessage is disabled. Cannot access the original message.");
        }
        return this.originalInMessage;
    }

    @Override
    public boolean isTransacted() {
        return this.transactedBy != null && !this.transactedBy.isEmpty();
    }

    @Override
    public boolean isTransactedBy(Object key) {
        return this.transactedBy != null && this.getTransactedBy().contains(key);
    }

    @Override
    public void beginTransactedBy(Object key) {
        this.exchange.getExchangeExtension().setTransacted(true);
        this.getTransactedBy().add(key);
    }

    @Override
    public void endTransactedBy(Object key) {
        this.getTransactedBy().remove(key);
        boolean transacted = this.isTransacted();
        this.exchange.getExchangeExtension().setTransacted(transacted);
    }

    @Override
    public Route getRoute() {
        return this.routes.peek();
    }

    @Override
    public void pushRoute(Route route) {
        this.routes.push(route);
    }

    @Override
    public Route popRoute() {
        return this.routes.poll();
    }

    @Override
    public int routeStackLevel() {
        return this.routes.size();
    }

    @Override
    public int routeStackLevel(boolean includeRouteTemplate, boolean includeKamelet) {
        if (includeKamelet && includeRouteTemplate) {
            return this.routes.size();
        }
        int level = 0;
        for (Route r : this.routes) {
            if (r.isCreatedByKamelet()) {
                if (!includeKamelet) continue;
                ++level;
                continue;
            }
            if (r.isCreatedByRouteTemplate()) {
                if (!includeRouteTemplate) continue;
                ++level;
                continue;
            }
            ++level;
        }
        return level;
    }

    @Override
    public boolean isBeforeAfterProcess() {
        return false;
    }

    @Override
    public AsyncCallback beforeProcess(Processor processor, Exchange exchange2, AsyncCallback callback) {
        return this.isBeforeAfterProcess() ? new UnitOfWorkCallback(callback, processor) : callback;
    }

    @Override
    public void afterProcess(Processor processor, Exchange exchange2, AsyncCallback callback, boolean doneSync) {
    }

    private Set<Object> getTransactedBy() {
        if (this.transactedBy == null) {
            this.transactedBy = new HashSet<Object>(4);
        }
        return this.transactedBy;
    }

    public String toString() {
        return "DefaultUnitOfWork";
    }

    private final class UnitOfWorkCallback
    implements AsyncCallback {
        private final AsyncCallback delegate;
        private final Processor processor;

        private UnitOfWorkCallback(AsyncCallback delegate, Processor processor) {
            this.delegate = delegate;
            this.processor = processor;
        }

        @Override
        public void done(boolean doneSync) {
            this.delegate.done(doneSync);
            DefaultUnitOfWork.this.afterProcess(this.processor, DefaultUnitOfWork.this.exchange, this.delegate, doneSync);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

