/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PooledExchange;
import org.apache.camel.impl.engine.PrototypeExchangeFactory;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.support.DefaultPooledExchange;
import org.apache.camel.support.ResetableClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PooledExchangeFactory
extends PrototypeExchangeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PooledExchangeFactory.class);
    private final ReleaseOnDoneTask onDone = new ReleaseOnDoneTask();

    public PooledExchangeFactory() {
    }

    public PooledExchangeFactory(Consumer consumer) {
        super(consumer);
    }

    @Override
    public ExchangeFactory newExchangeFactory(Consumer consumer) {
        PooledExchangeFactory answer = new PooledExchangeFactory(consumer);
        answer.setCamelContext(this.camelContext);
        answer.setCapacity(this.capacity);
        answer.setStatisticsEnabled(this.statisticsEnabled);
        return answer;
    }

    @Override
    public Exchange create(boolean autoRelease) {
        Exchange exchange2 = (Exchange)this.pool.poll();
        if (exchange2 == null) {
            exchange2 = this.createPooledExchange(null, autoRelease);
            if (this.statisticsEnabled) {
                this.statistics.created.increment();
            }
        } else if (this.statisticsEnabled) {
            this.statistics.acquired.increment();
        }
        ((ResetableClock)exchange2.getClock()).reset();
        return exchange2;
    }

    @Override
    public Exchange create(Endpoint fromEndpoint, boolean autoRelease) {
        Exchange exchange2 = (Exchange)this.pool.poll();
        if (exchange2 == null) {
            exchange2 = this.createPooledExchange(fromEndpoint, autoRelease);
            if (this.statisticsEnabled) {
                this.statistics.created.increment();
            }
        } else if (this.statisticsEnabled) {
            this.statistics.acquired.increment();
        }
        ((ResetableClock)exchange2.getClock()).reset();
        return exchange2;
    }

    @Override
    public boolean release(Exchange exchange2) {
        try {
            PooledExchange ee = (PooledExchange)exchange2;
            ee.done();
            boolean inserted = this.pool.offer(exchange2);
            if (this.statisticsEnabled) {
                if (inserted) {
                    this.statistics.released.increment();
                } else {
                    this.statistics.discarded.increment();
                }
            }
            return inserted;
        }
        catch (Exception e) {
            if (this.statisticsEnabled) {
                this.statistics.discarded.increment();
            }
            LOG.debug("Error resetting exchange: {}. This exchange is discarded.", (Object)exchange2);
            return false;
        }
    }

    private PooledExchange createPooledExchange(Endpoint fromEndpoint, boolean autoRelease) {
        DefaultPooledExchange answer = fromEndpoint != null ? DefaultPooledExchange.newFromEndpoint(fromEndpoint) : new DefaultPooledExchange(this.camelContext);
        answer.setAutoRelease(autoRelease);
        if (autoRelease) {
            answer.onDone(this.onDone);
        }
        return answer;
    }

    @Override
    public boolean isPooled() {
        return true;
    }

    @Override
    protected void doStop() throws Exception {
        if (this.exchangeFactoryManager != null) {
            this.exchangeFactoryManager.removeExchangeFactory(this);
        }
        if (this.pool != null) {
            this.logUsageSummary(LOG, "PooledExchangeFactory", this.pool.size());
            this.pool.clear();
        }
    }

    private final class ReleaseOnDoneTask
    implements PooledExchange.OnDoneTask {
        private ReleaseOnDoneTask() {
        }

        @Override
        public void onDone(Exchange exchange2) {
            PooledExchangeFactory.this.release(exchange2);
        }
    }
}

