/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.PooledObjectFactorySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototypeProcessorExchangeFactory
extends PooledObjectFactorySupport<Exchange>
implements ProcessorExchangeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PrototypeProcessorExchangeFactory.class);
    final Processor processor;
    String routeId;
    String id;

    public PrototypeProcessorExchangeFactory() {
        this.processor = null;
    }

    public PrototypeProcessorExchangeFactory(Processor processor) {
        this.processor = processor;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public ProcessorExchangeFactory newProcessorExchangeFactory(Processor processor) {
        PrototypeProcessorExchangeFactory answer = new PrototypeProcessorExchangeFactory(processor);
        answer.setStatisticsEnabled(this.statisticsEnabled);
        answer.setCapacity(this.capacity);
        answer.setCamelContext(this.camelContext);
        return answer;
    }

    @Override
    public Exchange createCopy(Exchange exchange2) {
        return exchange2.copy();
    }

    @Override
    public Exchange createCorrelatedCopy(Exchange exchange2, boolean handover) {
        return ExchangeHelper.createCorrelatedCopy(exchange2, handover);
    }

    @Override
    public Exchange create(Endpoint fromEndpoint, ExchangePattern exchangePattern) {
        return DefaultExchange.newFromEndpoint(fromEndpoint, exchangePattern);
    }

    @Override
    public Exchange acquire() {
        throw new UnsupportedOperationException("Not in use");
    }

    @Override
    public boolean release(Exchange exchange2) {
        if (this.statisticsEnabled) {
            this.statistics.released.increment();
        }
        return true;
    }

    @Override
    public boolean isPooled() {
        return false;
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.logUsageSummary(LOG, "PrototypeProcessorExchangeFactory", 0);
    }

    void logUsageSummary(Logger log, String name, int pooled) {
        if (this.statisticsEnabled && this.processor != null) {
            boolean shouldLog;
            long created = this.statistics.getCreatedCounter();
            long acquired = this.statistics.getAcquiredCounter();
            long released = this.statistics.getReleasedCounter();
            long discarded = this.statistics.getDiscardedCounter();
            boolean bl = shouldLog = pooled > 0 || created > 0L || acquired > 0L || released > 0L || discarded > 0L;
            if (shouldLog) {
                boolean leak;
                String rid = this.getRouteId();
                String pid = this.getId();
                boolean bl2 = leak = created + acquired > released + discarded;
                if (leak) {
                    long leaks = created + acquired - (released + discarded);
                    log.warn("{} {} ({}) usage (leaks detected: {}) [pooled: {}, created: {}, acquired: {} released: {}, discarded: {}]", new Object[]{name, rid, pid, leaks, pooled, created, acquired, released, discarded});
                } else {
                    log.info("{} {} ({}) usage [pooled: {}, created: {}, acquired: {} released: {}, discarded: {}]", new Object[]{name, rid, pid, pooled, created, acquired, released, discarded});
                }
            }
        }
    }
}

