/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.StreamCacheException;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.util.ObjectHelper;

final class StreamCachingHelper {
    private StreamCachingHelper() {
    }

    public static StreamCache convertToStreamCache(StreamCachingStrategy strategy, Exchange exchange2, Message message) {
        try {
            Object body2 = message.getBody();
            if (body2 == null) {
                return null;
            }
            if (body2 instanceof StreamCache) {
                StreamCache sc = (StreamCache)body2;
                sc.reset();
                return sc;
            }
        }
        catch (Exception e) {
            StreamCachingHelper.handleException(exchange2, null, e);
        }
        Throwable cause = exchange2.getException();
        if (cause == null) {
            cause = exchange2.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
        }
        return StreamCachingHelper.tryStreamCache(strategy, exchange2, message, cause);
    }

    private static StreamCache tryStreamCache(StreamCachingStrategy strategy, Exchange exchange2, Message inMessage, Throwable cause) {
        boolean failed;
        boolean bl = failed = cause != null && ObjectHelper.getException(StreamCacheException.class, cause) != null;
        if (!failed) {
            boolean disabled = exchange2.getExchangeExtension().isStreamCacheDisabled();
            if (disabled) {
                return null;
            }
            try {
                StreamCache sc = strategy.cache(exchange2);
                if (sc != null) {
                    inMessage.setBody(sc);
                }
                return sc;
            }
            catch (Exception e) {
                StreamCachingHelper.handleException(exchange2, e);
            }
        }
        return null;
    }

    private static void handleException(Exchange exchange2, Exception e) {
        StreamCachingHelper.handleException(exchange2, exchange2.getMessage().getBody(), e);
    }

    private static void handleException(Exchange exchange2, Object value, Exception e) {
        StreamCacheException tce = new StreamCacheException(value, (Throwable)e);
        exchange2.setException(tce);
        exchange2.getExchangeExtension().setRedeliveryExhausted(true);
    }
}

