/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.SetVariableDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,transformation")
@XmlRootElement(name="setVariables")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SetVariablesDefinition
extends ProcessorDefinition<SetVariablesDefinition> {
    @XmlElementRef(name="variables")
    private List<SetVariableDefinition> variables = new ArrayList<SetVariableDefinition>();

    public SetVariablesDefinition() {
    }

    protected SetVariablesDefinition(SetVariablesDefinition source) {
        super(source);
        this.variables = ProcessorDefinitionHelper.deepCopyDefinitions(source.variables);
    }

    @Override
    public SetVariablesDefinition copyDefinition() {
        return new SetVariablesDefinition(this);
    }

    public SetVariablesDefinition(Object ... variableNamesAndExprs) {
        this.createSetVariableDefinitions(variableNamesAndExprs);
    }

    private void createSetVariableDefinitions(Object[] variableNamesAndExprs) {
        if (variableNamesAndExprs.length == 1 && variableNamesAndExprs[0] instanceof Map) {
            this.createVariablesFromMap((Map)variableNamesAndExprs[0]);
        } else {
            if (variableNamesAndExprs.length % 2 != 0) {
                throw new IllegalArgumentException("Must be a Map or have an even number of arguments!");
            }
            for (int i2 = 0; i2 < variableNamesAndExprs.length; i2 += 2) {
                this.addVariable(variableNamesAndExprs[i2], variableNamesAndExprs[i2 + 1]);
            }
        }
    }

    private void addVariable(Object key, Object value) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("Keys must be Strings");
        }
        if (!(value instanceof Expression)) {
            value = ExpressionBuilder.constantExpression(value);
        }
        this.variables.add(new SetVariableDefinition((String)key, (Expression)value));
    }

    private void createVariablesFromMap(Map<?, ?> variableMap) {
        for (Map.Entry<?, ?> entry : variableMap.entrySet()) {
            this.addVariable(entry.getKey(), entry.getValue());
        }
    }

    public List<SetVariableDefinition> getVariables() {
        return this.variables;
    }

    public void setVariables(List<SetVariableDefinition> variables) {
        this.variables = variables;
    }

    @Override
    public String getLabel() {
        return "setVariables[" + this.getVariableNames() + "]";
    }

    private String getVariableNames() {
        StringJoiner sb = new StringJoiner(",");
        for (SetVariableDefinition def : this.variables) {
            sb.add(def.getName());
        }
        return sb.toString();
    }

    @Override
    public String getShortName() {
        return "setVariables";
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return Collections.emptyList();
    }
}

