/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.InterceptableProcessor;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware,
RouteIdAware,
InterceptableProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CatchProcessor.class);
    private final CamelContext camelContext;
    private String id;
    private String routeId;
    private final List<Class<? extends Throwable>> exceptions;
    private boolean extendedStatistics;
    private ConcurrentMap<String, AtomicLong> exceptionMatches;
    private final Predicate onWhen;
    private transient long matches;

    public CatchProcessor(CamelContext camelContext, List<Class<? extends Throwable>> exceptions, Processor processor, Predicate onWhen) {
        super(processor);
        this.camelContext = camelContext;
        this.exceptions = exceptions;
        this.onWhen = onWhen;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (this.onWhen != null) {
            this.onWhen.init(this.camelContext);
        }
        if (this.camelContext.getManagementStrategy() != null && this.camelContext.getManagementStrategy().getManagementAgent() != null) {
            this.extendedStatistics = this.camelContext.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended();
            this.exceptionMatches = new ConcurrentHashMap<String, AtomicLong>();
        } else {
            this.extendedStatistics = false;
        }
    }

    @Override
    public String toString() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public String getTraceLabel() {
        return "catch";
    }

    @Override
    public boolean canIntercept() {
        return false;
    }

    @Override
    public boolean process(final Exchange exchange2, final AsyncCallback callback) {
        String routeId;
        final Exception e = exchange2.getException();
        Throwable caught = this.catches(exchange2, e);
        if (exchange2.getProperty(ExchangePropertyKey.EXCEPTION_HANDLED) != null || caught == null) {
            callback.done(true);
            return true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("This CatchProcessor catches the exception: {} caused by: {}", (Object)caught.getClass().getName(), (Object)e.getMessage());
        }
        final boolean stop = exchange2.isRouteStop();
        exchange2.setRouteStop(false);
        final boolean rollbackOnly = exchange2.isRollbackOnly();
        exchange2.setRollbackOnly(false);
        final boolean rollbackOnlyLast = exchange2.isRollbackOnlyLast();
        exchange2.setRollbackOnlyLast(false);
        if (exchange2.getProperty(ExchangePropertyKey.FAILURE_ENDPOINT) == null) {
            exchange2.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, exchange2.getProperty(ExchangePropertyKey.TO_ENDPOINT));
        }
        if ((routeId = ExchangeHelper.getAtRouteId(exchange2)) != null) {
            exchange2.setProperty(ExchangePropertyKey.FAILURE_ROUTE_ID, (Object)routeId);
        }
        exchange2.setProperty(ExchangePropertyKey.EXCEPTION_HANDLED, (Object)true);
        exchange2.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, (Object)e);
        exchange2.setException(null);
        exchange2.getExchangeExtension().setRedeliveryExhausted(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("The exception is handled for the exception: {} caused by: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
        EventHelper.notifyExchangeFailureHandling(exchange2.getContext(), exchange2, this.processor, false, null);
        boolean sync = this.processor.process(exchange2, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                EventHelper.notifyExchangeFailureHandled(exchange2.getContext(), exchange2, CatchProcessor.this.processor, false, null);
                exchange2.getExchangeExtension().setRedeliveryExhausted(false);
                if (rollbackOnly || rollbackOnlyLast || stop) {
                    exchange2.setRouteStop(stop);
                    exchange2.setRollbackOnly(rollbackOnly);
                    exchange2.setRollbackOnlyLast(rollbackOnlyLast);
                    if (e instanceof RollbackExchangeException) {
                        exchange2.setException(e);
                    }
                }
                if (!doneSync) {
                    ExchangeHelper.prepareOutToIn(exchange2);
                }
                callback.done(doneSync);
            }
        });
        return sync;
    }

    protected Throwable catches(Exchange exchange2, Throwable exception) {
        for (Throwable e : ObjectHelper.createExceptionIterable(exception)) {
            for (Class<? extends Throwable> type : this.exceptions) {
                if (!type.isInstance(e) || !this.matchesWhen(exchange2)) continue;
                if (this.extendedStatistics) {
                    String fqn = exception.getClass().getName();
                    AtomicLong match = this.exceptionMatches.computeIfAbsent(fqn, k -> new AtomicLong());
                    match.incrementAndGet();
                }
                ++this.matches;
                return e;
            }
        }
        return null;
    }

    public long getCaughtCount() {
        return this.matches;
    }

    public long getCaughtCount(String className) {
        AtomicLong cnt = (AtomicLong)this.exceptionMatches.get(className);
        return cnt != null ? cnt.get() : 0L;
    }

    public void reset() {
        this.matches = 0L;
        this.exceptionMatches.values().forEach(c -> c.set(0L));
    }

    public Set<String> getCaughtExceptionClassNames() {
        return this.exceptionMatches.keySet();
    }

    protected boolean matchesWhen(Exchange exchange2) {
        if (this.onWhen == null) {
            return true;
        }
        return this.onWhen.matches(exchange2);
    }
}

