/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.processor.ClaimCheckAggregationStrategy;
import org.apache.camel.processor.DefaultClaimCheckRepository;
import org.apache.camel.spi.ClaimCheckRepository;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaimCheckProcessor
extends AsyncProcessorSupport
implements IdAware,
RouteIdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(ClaimCheckProcessor.class);
    private CamelContext camelContext;
    private String id;
    private String routeId;
    private String operation;
    private AggregationStrategy aggregationStrategy;
    private String key;
    private Expression keyExpression;
    private String filter;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter2) {
        this.filter = filter2;
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        ClaimCheckRepository repo = ClaimCheckProcessor.getClaimCheckRepository(exchange2);
        try {
            String claimKey = this.keyExpression.evaluate(exchange2, String.class);
            switch (this.operation) {
                case "Set": {
                    ClaimCheckProcessor.operationSetHandler(exchange2, claimKey, repo);
                    break;
                }
                case "Get": {
                    this.operationGetHandler(exchange2, claimKey, repo);
                    break;
                }
                case "GetAndRemove": {
                    this.operationGetAndRemoveHandler(exchange2, claimKey, repo);
                    break;
                }
                case "Push": {
                    ClaimCheckProcessor.operationPushHandler(exchange2, claimKey, repo);
                    break;
                }
                case "Pop": {
                    this.operationPopHandler(exchange2, claimKey, repo);
                }
            }
        }
        catch (Exception e) {
            exchange2.setException(e);
        }
        callback.done(true);
        return true;
    }

    private void operationPopHandler(Exchange exchange2, String claimKey, ClaimCheckRepository repo) {
        Exchange copy = repo.pop();
        LOG.debug("Pop: {} -> {}", (Object)claimKey, (Object)exchange2);
        if (copy != null) {
            ExchangeHelper.prepareAggregation(exchange2, copy);
            Exchange result = this.aggregationStrategy.aggregate(exchange2, copy);
            if (result != null) {
                ExchangeHelper.copyResultsPreservePattern(exchange2, result);
            }
        }
    }

    private static void operationPushHandler(Exchange exchange2, String claimKey, ClaimCheckRepository repo) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange2, false);
        LOG.debug("Push: {} -> {}", (Object)claimKey, (Object)copy);
        repo.push(copy);
    }

    private void operationGetAndRemoveHandler(Exchange exchange2, String claimKey, ClaimCheckRepository repo) {
        Exchange copy = repo.getAndRemove(claimKey);
        LOG.debug("GetAndRemove: {} -> {}", (Object)claimKey, (Object)exchange2);
        if (copy != null) {
            ExchangeHelper.prepareAggregation(exchange2, copy);
            Exchange result = this.aggregationStrategy.aggregate(exchange2, copy);
            if (result != null) {
                ExchangeHelper.copyResultsPreservePattern(exchange2, result);
            }
        }
    }

    private void operationGetHandler(Exchange exchange2, String claimKey, ClaimCheckRepository repo) {
        Exchange result;
        Exchange copy = repo.get(claimKey);
        LOG.debug("Get: {} -> {}", (Object)claimKey, (Object)exchange2);
        if (copy != null && (result = this.aggregationStrategy.aggregate(exchange2, copy)) != null) {
            ExchangeHelper.copyResultsPreservePattern(exchange2, result);
        }
    }

    private static void operationSetHandler(Exchange exchange2, String claimKey, ClaimCheckRepository repo) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange2, false);
        boolean addedNew = repo.add(claimKey, copy);
        if (addedNew) {
            LOG.debug("Add: {} -> {}", (Object)claimKey, (Object)copy);
        } else {
            LOG.debug("Override: {} -> {}", (Object)claimKey, (Object)copy);
        }
    }

    private static ClaimCheckRepository getClaimCheckRepository(Exchange exchange2) {
        ClaimCheckRepository repo = exchange2.getProperty(ExchangePropertyKey.CLAIM_CHECK_REPOSITORY, ClaimCheckRepository.class);
        if (repo == null) {
            repo = new DefaultClaimCheckRepository();
            exchange2.setProperty(ExchangePropertyKey.CLAIM_CHECK_REPOSITORY, (Object)repo);
        }
        return repo;
    }

    @Override
    protected void doInit() throws Exception {
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = this.createAggregationStrategy();
        }
        CamelContextAware.trySetCamelContext(this.aggregationStrategy, this.camelContext);
        this.keyExpression = LanguageSupport.hasSimpleFunction(this.key) ? this.camelContext.resolveLanguage("simple").createExpression(this.key) : this.camelContext.resolveLanguage("constant").createExpression(this.key);
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.operation, "operation", this);
        ServiceHelper.startService((Object)this.aggregationStrategy);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.aggregationStrategy);
    }

    public String toString() {
        return this.id;
    }

    protected AggregationStrategy createAggregationStrategy() {
        ClaimCheckAggregationStrategy answer = new ClaimCheckAggregationStrategy();
        answer.setFilter(this.filter);
        return answer;
    }
}

