/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelayProcessorSupport
extends DelegateAsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DelayProcessorSupport.class);
    private final CamelContext camelContext;
    private final ScheduledExecutorService executorService;
    private final boolean shutdownExecutorService;
    private boolean asyncDelayed = true;
    private boolean callerRunsWhenRejected = true;
    private final AtomicInteger delayedCount = new AtomicInteger();

    public DelayProcessorSupport(CamelContext camelContext, Processor processor) {
        this(camelContext, processor, null, false);
    }

    public DelayProcessorSupport(CamelContext camelContext, Processor processor, ScheduledExecutorService executorService, boolean shutdownExecutorService) {
        super(processor);
        this.camelContext = camelContext;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processDelay(Exchange exchange2, AsyncCallback callback, long delay) {
        if (!this.isAsyncDelayed() || exchange2.isTransacted()) {
            try {
                this.delay(delay, exchange2);
                return this.processor.process(exchange2, callback);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                exchange2.setException(e);
                callback.done(true);
                return true;
            }
            catch (Exception e) {
                exchange2.setException(e);
                callback.done(true);
                return true;
            }
        }
        this.delayedCount.incrementAndGet();
        ProcessCall call = new ProcessCall(exchange2, callback);
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Scheduling delayed task to run in {} millis for exchangeId: {}", (Object)delay, (Object)exchange2.getExchangeId());
            }
            this.executorService.schedule(call, delay, TimeUnit.MILLISECONDS);
            return false;
        }
        catch (RejectedExecutionException e) {
            block13: {
                this.delayedCount.decrementAndGet();
                if (this.isCallerRunsWhenRejected()) {
                    if (!this.isRunAllowed()) {
                        exchange2.setException(new RejectedExecutionException());
                        break block13;
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Scheduling rejected task, so letting caller run, delaying at first for {} millis for exchangeId: {}", (Object)delay, (Object)exchange2.getExchangeId());
                        }
                        try {
                            this.delay(delay, exchange2);
                            return this.processor.process(exchange2, callback);
                        }
                        catch (InterruptedException ie) {
                            exchange2.setException(ie);
                            Thread.currentThread().interrupt();
                        }
                        return this.processor.process(exchange2, callback);
                    }
                }
                exchange2.setException(e);
            }
            callback.done(true);
            return true;
        }
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        long delay;
        if (!this.isRunAllowed()) {
            exchange2.setException(new RejectedExecutionException("Run is not allowed"));
            callback.done(true);
            return true;
        }
        try {
            delay = this.calculateDelay(exchange2);
            if (delay <= 0L) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("No delay for exchangeId: {}", (Object)exchange2.getExchangeId());
                }
                return this.processor.process(exchange2, callback);
            }
        }
        catch (Exception e) {
            exchange2.setException(e);
            callback.done(true);
            return true;
        }
        return this.processDelay(exchange2, callback, delay);
    }

    public boolean isAsyncDelayed() {
        return this.asyncDelayed;
    }

    public void setAsyncDelayed(boolean asyncDelayed) {
        this.asyncDelayed = asyncDelayed;
    }

    public boolean isCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    protected abstract long calculateDelay(Exchange var1);

    public int getDelayedCount() {
        return this.delayedCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delay(long delay, Exchange exchange2) throws InterruptedException {
        if (!this.isRunAllowed()) {
            return;
        }
        if (delay >= 0L) {
            try {
                this.delayedCount.incrementAndGet();
                this.sleep(delay);
            }
            catch (InterruptedException e) {
                this.handleSleepInterruptedException(e, exchange2);
            }
            finally {
                this.delayedCount.decrementAndGet();
            }
        }
    }

    protected void handleSleepInterruptedException(InterruptedException e, Exchange exchange2) throws InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sleep interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
        }
        Thread.currentThread().interrupt();
        throw e;
    }

    protected long currentSystemTime() {
        return System.currentTimeMillis();
    }

    private void sleep(long delay) throws InterruptedException {
        if (delay <= 0L) {
            return;
        }
        LOG.trace("Sleeping for: {} millis", (Object)delay);
        Thread.sleep(delay);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isAsyncDelayed()) {
            ObjectHelper.notNull(this.executorService, "executorService", this);
        } else if (this.executorService != null) {
            this.asyncDelayed = true;
        }
        super.doStart();
    }

    @Override
    protected void doShutdown() throws Exception {
        if (this.shutdownExecutorService && this.executorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executorService);
        }
        super.doShutdown();
    }

    private final class ProcessCall
    implements Runnable {
        private final Exchange exchange;
        private final AsyncCallback callback;

        ProcessCall(Exchange exchange2, AsyncCallback callback) {
            this.exchange = exchange2;
            this.callback = callback;
        }

        @Override
        public void run() {
            DelayProcessorSupport.this.delayedCount.decrementAndGet();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Delayed task woke up and continues routing for exchangeId: {}", (Object)this.exchange.getExchangeId());
            }
            if (!DelayProcessorSupport.this.isRunAllowed()) {
                this.exchange.setException(new RejectedExecutionException("Run is not allowed"));
            }
            DelayProcessorSupport.this.processor.process(this.exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Delayed task done for exchangeId: {}", (Object)ProcessCall.this.exchange.getExchangeId());
                    }
                    ProcessCall.this.callback.done(false);
                }
            });
        }
    }
}

