/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FatalFallbackErrorHandler
extends DelegateAsyncProcessor
implements ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FatalFallbackErrorHandler.class);
    private final boolean deadLetterChannel;

    public FatalFallbackErrorHandler(Processor processor) {
        this(processor, false);
    }

    public FatalFallbackErrorHandler(Processor processor, boolean isDeadLetterChannel) {
        super(processor);
        this.deadLetterChannel = isDeadLetterChannel;
    }

    @Override
    public boolean process(final Exchange exchange2, final AsyncCallback callback) {
        final String id = ExpressionBuilder.routeIdExpression().evaluate(exchange2, String.class);
        ArrayDeque<String> fatals = exchange2.getProperty(ExchangePropertyKey.FATAL_FALLBACK_ERROR_HANDLER, Deque.class);
        if (fatals == null) {
            fatals = new ArrayDeque<String>();
            exchange2.setProperty(ExchangePropertyKey.FATAL_FALLBACK_ERROR_HANDLER, fatals);
        }
        if (fatals.contains(id)) {
            LOG.warn("Circular error-handler detected at route: {} - breaking out processing Exchange: {}", (Object)id, (Object)exchange2);
            exchange2.getExchangeExtension().setErrorHandlerHandled(false);
            exchange2.setProperty(ExchangePropertyKey.ERRORHANDLER_CIRCUIT_DETECTED, (Object)true);
            callback.done(true);
            return true;
        }
        fatals.push(id);
        boolean sync = this.processor.process(exchange2, new AsyncCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done(boolean doneSync) {
                try {
                    if (exchange2.getException() != null) {
                        Throwable previous = exchange2.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
                        if (previous != null && previous == exchange2.getException()) {
                            previous = null;
                            if (exchange2.getException().getSuppressed().length > 0) {
                                previous = exchange2.getException().getSuppressed()[0];
                            }
                        }
                        String msg = "Exception occurred while trying to handle previously thrown exception on exchangeId: " + exchange2.getExchangeId() + " using: [" + FatalFallbackErrorHandler.this.processor + "].";
                        if (previous != null) {
                            msg = msg + " The previous and the new exception will be logged in the following.";
                            FatalFallbackErrorHandler.this.log(msg);
                            FatalFallbackErrorHandler.this.log("\\--> Previous exception on exchangeId: " + exchange2.getExchangeId(), previous);
                            FatalFallbackErrorHandler.this.log("\\--> New exception on exchangeId: " + exchange2.getExchangeId(), exchange2.getException());
                        } else {
                            FatalFallbackErrorHandler.this.log(msg);
                            FatalFallbackErrorHandler.this.log("\\--> New exception on exchangeId: " + exchange2.getExchangeId(), exchange2.getException());
                        }
                        if (previous != null) {
                            Throwable[] suppressed = exchange2.getException().getSuppressed();
                            boolean found = false;
                            for (Throwable t : suppressed) {
                                if (t != previous) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                exchange2.getException().addSuppressed(previous);
                            }
                        }
                        exchange2.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, (Object)exchange2.getException());
                        if (FatalFallbackErrorHandler.this.deadLetterChannel) {
                            exchange2.getExchangeExtension().setErrorHandlerHandled(null);
                        } else {
                            exchange2.getExchangeExtension().setErrorHandlerHandled(false);
                        }
                    }
                }
                finally {
                    Deque fatals = exchange2.getProperty(ExchangePropertyKey.FATAL_FALLBACK_ERROR_HANDLER, Deque.class);
                    if (fatals != null) {
                        fatals.removeLastOccurrence(id);
                    }
                    callback.done(doneSync);
                }
            }
        });
        return sync;
    }

    private void log(String message) {
        this.log(message, null);
    }

    private void log(String message, Throwable t) {
        if (this.deadLetterChannel) {
            if (t != null) {
                LOG.warn(message, t);
            } else {
                LOG.warn(message);
            }
        } else if (t != null) {
            LOG.error(message, t);
        } else {
            LOG.error(message);
        }
    }

    @Override
    public String toString() {
        return "FatalFallbackErrorHandler[" + this.processor + "]";
    }
}

