/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Ordered;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.SynchronizationRouteAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnCompletionProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(OnCompletionProcessor.class);
    private final CamelContext camelContext;
    private String id;
    private String routeId;
    private final Processor processor;
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private final boolean onCompleteOnly;
    private final boolean onFailureOnly;
    private final Predicate onWhen;
    private final boolean useOriginalBody;
    private final boolean afterConsumer;
    private final boolean routeScoped;

    public OnCompletionProcessor(CamelContext camelContext, Processor processor, ExecutorService executorService, boolean shutdownExecutorService, boolean onCompleteOnly, boolean onFailureOnly, Predicate onWhen, boolean useOriginalBody, boolean afterConsumer, boolean routeScoped) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(processor, "processor");
        this.camelContext = camelContext;
        this.processor = processor;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.onCompleteOnly = onCompleteOnly;
        this.onFailureOnly = onFailureOnly;
        this.onWhen = onWhen;
        this.useOriginalBody = useOriginalBody;
        this.afterConsumer = afterConsumer;
        this.routeScoped = routeScoped;
    }

    @Override
    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.processor);
        if (this.shutdownExecutorService) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        if (this.processor != null) {
            if (this.afterConsumer) {
                exchange2.getUnitOfWork().addSynchronization(new OnCompletionSynchronizationAfterConsumer(this.routeScoped, this.getRouteId()));
            } else {
                exchange2.getUnitOfWork().addSynchronization(new OnCompletionSynchronizationBeforeConsumer(this.routeScoped, this.getRouteId()));
            }
        }
        callback.done(true);
        return true;
    }

    protected boolean isCreateCopy() {
        return this.executorService != null || this.afterConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doProcess(Processor processor, Exchange exchange2) {
        boolean stop = exchange2.isRouteStop();
        exchange2.setRouteStop(false);
        boolean failureHandled = exchange2.getExchangeExtension().isFailureHandled();
        Boolean errorhandlerHandled = exchange2.getExchangeExtension().getErrorHandlerHandled();
        exchange2.getExchangeExtension().setErrorHandlerHandled(null);
        boolean rollbackOnly = exchange2.isRollbackOnly();
        exchange2.setRollbackOnly(false);
        boolean rollbackOnlyLast = exchange2.isRollbackOnlyLast();
        exchange2.setRollbackOnlyLast(false);
        boolean exhausted = exchange2.getExchangeExtension().isRedeliveryExhausted();
        exchange2.getExchangeExtension().setRedeliveryExhausted(false);
        Exception cause = exchange2.getException();
        if (cause != null) {
            exchange2.setException(null);
        }
        try {
            processor.process(exchange2);
        }
        catch (Exception e) {
            exchange2.setException(e);
        }
        finally {
            exchange2.setRouteStop(stop);
            if (failureHandled) {
                exchange2.getExchangeExtension().setFailureHandled(true);
            }
            if (errorhandlerHandled != null) {
                exchange2.getExchangeExtension().setErrorHandlerHandled(errorhandlerHandled);
            }
            exchange2.setRollbackOnly(rollbackOnly);
            exchange2.setRollbackOnlyLast(rollbackOnlyLast);
            exchange2.getExchangeExtension().setRedeliveryExhausted(exhausted);
            if (cause != null) {
                if (exchange2.isFailed()) {
                    cause.addSuppressed(exchange2.getException());
                }
                exchange2.setException(cause);
            }
        }
    }

    protected Exchange prepareExchange(Exchange exchange2) {
        Exchange answer;
        if (this.isCreateCopy()) {
            answer = ExchangeHelper.createCorrelatedCopy(exchange2, false);
            if (answer.hasOut()) {
                answer.setIn(answer.getOut());
                answer.setOut(null);
            }
            answer.setPattern(ExchangePattern.InOnly);
        } else {
            answer = exchange2;
        }
        if (this.useOriginalBody) {
            LOG.trace("Using the original IN message instead of current");
            Message original = ExchangeHelper.getOriginalInMessage(exchange2);
            answer.setIn(original);
        }
        answer.setProperty(ExchangePropertyKey.ON_COMPLETION, (Object)Boolean.TRUE);
        return answer;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        return "onCompletion";
    }

    private final class OnCompletionSynchronizationAfterConsumer
    extends SynchronizationAdapter
    implements Ordered {
        private final boolean routeScoped;
        private final String routeId;

        public OnCompletionSynchronizationAfterConsumer(boolean routeScoped, String routeId) {
            this.routeScoped = routeScoped;
            this.routeId = routeId;
        }

        @Override
        public int getOrder() {
            return 2147482647;
        }

        @Override
        public SynchronizationRouteAware getRouteSynchronization() {
            return new SynchronizationRouteAware(){

                @Override
                public void onBeforeRoute(Route route, Exchange exchange2) {
                }

                @Override
                public void onAfterRoute(Route route, Exchange exchange2) {
                    if (OnCompletionSynchronizationAfterConsumer.this.routeScoped && route.getRouteId().equals(OnCompletionSynchronizationAfterConsumer.this.routeId)) {
                        ArrayList<String> routeIds = exchange2.getProperty(ExchangePropertyKey.ON_COMPLETION_ROUTE_IDS, List.class);
                        if (routeIds == null) {
                            routeIds = new ArrayList<String>();
                            exchange2.setProperty(ExchangePropertyKey.ON_COMPLETION_ROUTE_IDS, routeIds);
                        }
                        routeIds.add(route.getRouteId());
                    }
                }
            };
        }

        @Override
        public void onComplete(Exchange exchange2) {
            if (this.shouldSkip(exchange2, OnCompletionProcessor.this.onFailureOnly)) {
                return;
            }
            final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange2);
            if (OnCompletionProcessor.this.executorService != null) {
                OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        LOG.debug("Processing onComplete: {}", (Object)copy);
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                        return copy;
                    }
                });
            } else {
                LOG.debug("Processing onComplete: {}", (Object)copy);
                OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
            }
        }

        @Override
        public void onFailure(Exchange exchange2) {
            if (this.shouldSkip(exchange2, OnCompletionProcessor.this.onCompleteOnly)) {
                return;
            }
            final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange2);
            final Exception original = copy.getException();
            if (original != null) {
                copy.setException(null);
            }
            if (OnCompletionProcessor.this.executorService != null) {
                OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        LOG.debug("Processing onFailure: {}", (Object)copy);
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                        copy.setException(original);
                        return null;
                    }
                });
            } else {
                LOG.debug("Processing onFailure: {}", (Object)copy);
                OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                copy.setException(original);
            }
        }

        private boolean shouldSkip(Exchange exchange2, boolean onCompleteOrOnFailureOnly) {
            List routeIds;
            String currentRouteId = ExchangeHelper.getRouteId(exchange2);
            if (!this.routeScoped && currentRouteId != null && !this.routeId.equals(currentRouteId)) {
                return true;
            }
            if (this.routeScoped && ((routeIds = exchange2.getProperty(ExchangePropertyKey.ON_COMPLETION_ROUTE_IDS, List.class)) == null || !routeIds.contains(this.routeId))) {
                return true;
            }
            if (onCompleteOrOnFailureOnly) {
                return true;
            }
            return OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange2);
        }

        public String toString() {
            if (!OnCompletionProcessor.this.onCompleteOnly && !OnCompletionProcessor.this.onFailureOnly) {
                return "onCompleteOrFailure";
            }
            if (OnCompletionProcessor.this.onCompleteOnly) {
                return "onCompleteOnly";
            }
            return "onFailureOnly";
        }

        @Override
        public void beforeHandover(Exchange target) {
            LOG.debug("beforeHandover from Route {}", (Object)target.getFromRouteId());
            String exchangeRouteId = target.getFromRouteId();
            if (this.routeScoped && exchangeRouteId != null && exchangeRouteId.equals(this.routeId)) {
                ArrayList<String> routeIds = target.getProperty(ExchangePropertyKey.ON_COMPLETION_ROUTE_IDS, List.class);
                if (routeIds == null) {
                    routeIds = new ArrayList<String>();
                    target.setProperty(ExchangePropertyKey.ON_COMPLETION_ROUTE_IDS, routeIds);
                }
                if (!routeIds.contains(exchangeRouteId)) {
                    routeIds.add(exchangeRouteId);
                }
            }
        }
    }

    private final class OnCompletionSynchronizationBeforeConsumer
    extends SynchronizationAdapter
    implements Ordered {
        private final boolean routeScoped;
        private final String routeId;

        public OnCompletionSynchronizationBeforeConsumer(boolean routeScoped, String routeId) {
            this.routeScoped = routeScoped;
            this.routeId = routeId;
        }

        @Override
        public int getOrder() {
            return 2147482647;
        }

        @Override
        public SynchronizationRouteAware getRouteSynchronization() {
            return new SynchronizationRouteAware(){

                @Override
                public void onBeforeRoute(Route route, Exchange exchange2) {
                }

                @Override
                public void onAfterRoute(Route route, Exchange exchange2) {
                    LOG.debug("onAfterRoute from Route {}", (Object)route.getRouteId());
                    if (OnCompletionSynchronizationBeforeConsumer.this.routeScoped && !route.getRouteId().equals(OnCompletionSynchronizationBeforeConsumer.this.routeId)) {
                        return;
                    }
                    if (!(OnCompletionSynchronizationBeforeConsumer.this.routeScoped || route.getRouteId().equals(OnCompletionSynchronizationBeforeConsumer.this.routeId) && exchange2.getFromRouteId().equals(OnCompletionSynchronizationBeforeConsumer.this.routeId))) {
                        return;
                    }
                    if (exchange2.isFailed() && OnCompletionProcessor.this.onCompleteOnly) {
                        return;
                    }
                    if (!exchange2.isFailed() && OnCompletionProcessor.this.onFailureOnly) {
                        return;
                    }
                    if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange2)) {
                        return;
                    }
                    final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange2);
                    if (OnCompletionProcessor.this.executorService != null) {
                        OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                            @Override
                            public Exchange call() throws Exception {
                                LOG.debug("Processing onAfterRoute: {}", (Object)copy);
                                OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                                return copy;
                            }
                        });
                    } else {
                        LOG.debug("Processing onAfterRoute: {}", (Object)copy);
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                    }
                }
            };
        }

        @Override
        public boolean allowHandover() {
            return false;
        }

        public String toString() {
            return "onAfterRoute";
        }
    }
}

