/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.slf4j.Logger;

public final class PipelineHelper {
    private PipelineHelper() {
    }

    public static boolean continueProcessing(Exchange exchange2, String message, Logger log) {
        boolean stop;
        boolean bl = stop = exchange2.isFailed() || exchange2.isRollbackOnly() || exchange2.isRollbackOnlyLast() || exchange2.getExchangeExtension().isErrorHandlerHandledSet() && exchange2.getExchangeExtension().isErrorHandlerHandled();
        if (stop) {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder(256);
                sb.append("Message exchange has failed: ").append(message).append(" for exchange: ").append(exchange2);
                if (exchange2.isRollbackOnly() || exchange2.isRollbackOnlyLast()) {
                    sb.append(" Marked as rollback only.");
                }
                if (exchange2.getException() != null) {
                    sb.append(" Exception: ").append(exchange2.getException());
                }
                if (exchange2.getExchangeExtension().isErrorHandlerHandledSet() && exchange2.getExchangeExtension().isErrorHandlerHandled()) {
                    sb.append(" Handled by the error handler.");
                }
                log.debug(sb.toString());
            }
            return false;
        }
        if (exchange2.isRouteStop()) {
            if (log.isDebugEnabled()) {
                log.debug("ExchangeId: {} is marked to stop routing: {}", (Object)exchange2.getExchangeId(), (Object)exchange2);
            }
            return false;
        }
        return true;
    }
}

