/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Route;
import org.apache.camel.Traceable;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.processor.ProcessorHelper;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.cache.EmptyProducerCache;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingSlip
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingSlip.class);
    protected String id;
    protected String routeId;
    protected ProducerCache producerCache;
    protected int cacheSize;
    protected boolean ignoreInvalidEndpoints;
    protected String header;
    protected Expression expression;
    protected String uriDelimiter;
    protected final CamelContext camelContext;
    protected AsyncProcessor errorHandler;

    public RoutingSlip(CamelContext camelContext) {
        ObjectHelper.notNull(camelContext, "camelContext");
        this.camelContext = camelContext;
    }

    public RoutingSlip(CamelContext camelContext, Expression expression, String uriDelimiter) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(expression, "expression");
        this.camelContext = camelContext;
        this.expression = expression;
        this.uriDelimiter = uriDelimiter;
        this.header = null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }

    public void setDelimiter(String delimiter) {
        this.uriDelimiter = delimiter;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public AsyncProcessor getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(AsyncProcessor errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        return "routingSlip[" + this.expression + "]";
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        if (!this.isStarted()) {
            exchange2.setException(new IllegalStateException("RoutingSlip has not been started: " + this));
            callback.done(true);
            return true;
        }
        Expression exp = this.expression;
        Object slip = exchange2.removeProperty(ExchangePropertyKey.EVALUATE_EXPRESSION_RESULT);
        if (slip != null) {
            Expression expression;
            exp = slip instanceof Expression ? (expression = (Expression)slip) : ExpressionBuilder.constantExpression(slip);
        }
        return this.doRoutingSlipWithExpression(exchange2, exp, callback);
    }

    protected RoutingSlipIterator createRoutingSlipIterator(Exchange exchange2, Expression expression) throws Exception {
        Object slip = expression.evaluate(exchange2, Object.class);
        if (exchange2.getException() != null) {
            throw exchange2.getException();
        }
        final Iterator<?> delegate = org.apache.camel.support.ObjectHelper.createIterator(slip, this.uriDelimiter);
        return new RoutingSlipIterator(){

            @Override
            public boolean hasNext(Exchange exchange2) {
                return delegate.hasNext();
            }

            @Override
            public Object next(Exchange exchange2) {
                return delegate.next();
            }
        };
    }

    private boolean doRoutingSlipWithExpression(Exchange exchange2, Expression expression, AsyncCallback originalCallback) {
        RoutingSlipIterator iter;
        Exchange current = exchange2;
        try {
            iter = this.createRoutingSlipIterator(exchange2, expression);
        }
        catch (Exception e) {
            exchange2.setException(e);
            originalCallback.done(true);
            return true;
        }
        current.removeProperty(ExchangePropertyKey.SLIP_ENDPOINT);
        while (iter.hasNext(current)) {
            FailedToCreateProducerException e;
            Endpoint endpoint;
            boolean prototype = this.cacheSize < 0;
            try {
                Object recipient = iter.next(exchange2);
                recipient = RoutingSlip.prepareRecipient(exchange2, recipient);
                Endpoint existing = RoutingSlip.getExistingEndpoint(exchange2, recipient);
                if (existing == null) {
                    endpoint = this.resolveEndpoint(exchange2, recipient, prototype);
                } else {
                    endpoint = existing;
                    prototype = false;
                }
                if (endpoint == null) {
                    continue;
                }
            }
            catch (Exception e2) {
                current.setException(e2);
                break;
            }
            boolean sync = this.processExchange(endpoint, current, exchange2, originalCallback, iter, prototype);
            current = this.prepareExchangeForRoutingSlip(current, endpoint);
            if (!sync) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange2.getExchangeId());
                }
                return false;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange2.getExchangeId());
            }
            if (this.isIgnoreInvalidEndpoints() && (e = current.getException(FailedToCreateProducerException.class)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Endpoint uri is invalid: {}. This exception will be ignored.", (Object)endpoint, (Object)e);
                }
                current.setException(null);
            }
            if (PipelineHelper.continueProcessing(current, "so breaking out of the routing slip", LOG)) continue;
            break;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange2.getExchangeId(), (Object)current);
        }
        ExchangeHelper.copyResults(exchange2, current);
        originalCallback.done(true);
        return true;
    }

    protected static Object prepareRecipient(Exchange exchange2, Object recipient) throws NoTypeConversionAvailableException {
        return ProcessorHelper.prepareRecipient(exchange2, recipient);
    }

    protected static Endpoint getExistingEndpoint(Exchange exchange2, Object recipient) {
        return ProcessorHelper.getExistingEndpoint(exchange2, recipient);
    }

    protected Endpoint resolveEndpoint(Exchange exchange2, Object recipient, boolean prototype) throws Exception {
        Endpoint endpoint = null;
        try {
            endpoint = prototype ? ExchangeHelper.resolvePrototypeEndpoint(exchange2, recipient) : ExchangeHelper.resolveEndpoint(exchange2, recipient);
        }
        catch (Exception e) {
            if (this.isIgnoreInvalidEndpoints()) {
                LOG.debug("Endpoint uri is invalid: {}. This exception will be ignored.", recipient, (Object)e);
            }
            throw e;
        }
        return endpoint;
    }

    protected Exchange prepareExchangeForRoutingSlip(Exchange current, Endpoint endpoint) {
        Exchange copy = ExchangeHelper.createCopy(current, true);
        ExchangeHelper.prepareOutToIn(copy);
        MessageHelper.resetStreamCache(copy.getIn());
        return copy;
    }

    protected AsyncProcessor createErrorHandler(Route route, Exchange exchange2, AsyncProcessor processor, Endpoint endpoint) {
        AsyncProcessor answer = processor;
        boolean tryBlock = exchange2.getProperty(ExchangePropertyKey.TRY_ROUTE_BLOCK, Boolean.TYPE);
        if (!tryBlock && route != null && this.errorHandler != null) {
            answer = this.errorHandler;
        }
        return answer;
    }

    protected boolean processExchange(final Endpoint endpoint, final Exchange exchange2, final Exchange original, AsyncCallback originalCallback, final RoutingSlipIterator iter, final boolean prototype) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing exchangeId: {} >>> {}", (Object)exchange2.getExchangeId(), (Object)exchange2);
        }
        AsyncCallback callback = doneSync -> {
            if (!doneSync) {
                originalCallback.done(false);
            }
        };
        return this.producerCache.doInAsyncProducer(endpoint, exchange2, callback, (p, ex, cb) -> {
            Route route = ExchangeHelper.getRoute(ex);
            AsyncProcessor target = this.createErrorHandler(route, ex, p, endpoint);
            ex.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)endpoint.getEndpointUri());
            ex.setProperty(ExchangePropertyKey.SLIP_ENDPOINT, (Object)endpoint.getEndpointUri());
            ex.setProperty(ExchangePropertyKey.SLIP_PRODUCER, (Object)p);
            return target.process(ex, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    ex.removeProperty(ExchangePropertyKey.SLIP_PRODUCER);
                    if (doneSync) {
                        if (prototype) {
                            ServiceHelper.stopAndShutdownService(endpoint);
                        }
                        cb.done(true);
                        return;
                    }
                    try {
                        Exchange current = RoutingSlip.this.prepareExchangeForRoutingSlip(ex, endpoint);
                        while (iter.hasNext(current)) {
                            Endpoint nextEndpoint;
                            FailedToCreateProducerException e;
                            if (RoutingSlip.this.isIgnoreInvalidEndpoints() && (e = current.getException(FailedToCreateProducerException.class)) != null) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Endpoint uri is invalid: {}. This exception will be ignored.", (Object)endpoint, (Object)e);
                                }
                                current.setException(null);
                            }
                            if (!PipelineHelper.continueProcessing(current, "so breaking out of the routing slip", LOG)) break;
                            boolean prototype2 = RoutingSlip.this.cacheSize < 0;
                            try {
                                Object recipient = iter.next(ex);
                                recipient = RoutingSlip.prepareRecipient(exchange2, recipient);
                                Endpoint existing = RoutingSlip.getExistingEndpoint(exchange2, recipient);
                                if (existing == null) {
                                    nextEndpoint = RoutingSlip.this.resolveEndpoint(exchange2, recipient, prototype2);
                                } else {
                                    nextEndpoint = existing;
                                    prototype2 = false;
                                }
                                if (nextEndpoint == null) {
                                    continue;
                                }
                            }
                            catch (Exception e2) {
                                current.setException(e2);
                                break;
                            }
                            AsyncCallback cbNext = RoutingSlip.getNextCallback(prototype2, nextEndpoint, cb);
                            boolean sync = RoutingSlip.this.processExchange(nextEndpoint, current, original, cbNext, iter, prototype2);
                            current = RoutingSlip.this.prepareExchangeForRoutingSlip(current, nextEndpoint);
                            if (sync) continue;
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)original.getExchangeId());
                            }
                            return;
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)original.getExchangeId(), (Object)current);
                        }
                        ExchangeHelper.copyResults(original, current);
                    }
                    catch (Exception e) {
                        ex.setException(e);
                    }
                    cb.done(false);
                }
            });
        });
    }

    private static AsyncCallback getNextCallback(boolean prototype, Endpoint nextEndpoint, AsyncCallback cb) {
        boolean prototypeEndpoint = prototype;
        AsyncCallback cbNext = doneNext -> {
            if (prototypeEndpoint) {
                ServiceHelper.stopAndShutdownService(nextEndpoint);
            }
            cb.done(doneNext);
        };
        return cbNext;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.producerCache == null) {
            if (this.cacheSize < 0) {
                this.producerCache = new EmptyProducerCache(this, this.camelContext);
                LOG.debug("RoutingSlip {} is not using ProducerCache", (Object)this);
            } else {
                this.producerCache = new DefaultProducerCache(this, this.camelContext, this.cacheSize);
                LOG.debug("RoutingSlip {} using ProducerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
            }
        }
        ServiceHelper.startService(this.producerCache, this.errorHandler);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producerCache, this.errorHandler);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.producerCache, this.errorHandler);
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.producerCache.getEndpointUtilizationStatistics();
    }

    public AsyncProcessor newRoutingSlipProcessorForErrorHandler() {
        return new RoutingSlipProcessor();
    }

    protected static interface RoutingSlipIterator {
        public boolean hasNext(Exchange var1);

        public Object next(Exchange var1);
    }

    private static final class RoutingSlipProcessor
    extends AsyncProcessorSupport {
        private RoutingSlipProcessor() {
        }

        @Override
        public boolean process(Exchange exchange2, AsyncCallback callback) {
            AsyncProcessor producer = exchange2.getProperty(ExchangePropertyKey.SLIP_PRODUCER, AsyncProcessor.class);
            return producer.process(exchange2, callback);
        }

        public String toString() {
            return "RoutingSlipProcessor";
        }
    }
}

