/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;

public class SetHeadersProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final List<Expression> headerNames;
    private final List<Expression> expressions;

    public SetHeadersProcessor(List<Expression> headerNames, List<Expression> expressions) {
        this.headerNames = headerNames;
        this.expressions = expressions;
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        try {
            int headerIndex = 0;
            for (Expression expression : this.expressions) {
                Object newHeader = expression.evaluate(exchange2, Object.class);
                if (exchange2.getException() != null) {
                    callback.done(true);
                    return true;
                }
                Message message = exchange2.getMessage();
                String key = this.headerNames.get(headerIndex++).evaluate(exchange2, String.class);
                message.setHeader(key, newHeader);
            }
        }
        catch (Exception e) {
            exchange2.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("setHeaders[");
        int headerIndex = 0;
        for (Expression expression : this.expressions) {
            if (headerIndex > 0) {
                sb.append("; ");
            }
            sb.append(this.headerNames.get(headerIndex++).toString());
            sb.append(", ");
            sb.append(expression.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public List<Expression> getHeaderNames() {
        return this.headerNames;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }
}

