/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class SetVariableProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware,
CamelContextAware {
    private CamelContext camelContext;
    private String id;
    private String routeId;
    private final Expression variableName;
    private final Expression expression;

    public SetVariableProcessor(Expression variableName, Expression expression) {
        this.variableName = variableName;
        this.expression = expression;
        ObjectHelper.notNull(variableName, "variableName");
        ObjectHelper.notNull(expression, "expression");
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        try {
            Object newVariable = this.expression.evaluate(exchange2, Object.class);
            if (exchange2.getException() != null) {
                callback.done(true);
                return true;
            }
            String key = this.variableName.evaluate(exchange2, String.class);
            ExchangeHelper.setVariable(exchange2, key, newVariable);
        }
        catch (Exception e) {
            exchange2.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        return "setVariable[" + this.variableName + ", " + this.expression + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getVariableName() {
        return this.variableName.toString();
    }

    public Expression getExpression() {
        return this.expression;
    }
}

