/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.support.EventHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepProcessor
extends Pipeline {
    private static final Logger LOG = LoggerFactory.getLogger(StepProcessor.class);
    private final String stepId;

    public StepProcessor(CamelContext camelContext, Collection<Processor> processors, String stepId) {
        super(camelContext, processors);
        this.stepId = stepId;
    }

    public static Processor newInstance(CamelContext camelContext, List<Processor> processors, String stepId) {
        if (processors.isEmpty()) {
            return null;
        }
        return new StepProcessor(camelContext, processors, stepId);
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        Object oldStepId = exchange2.removeProperty(ExchangePropertyKey.STEP_ID);
        exchange2.setProperty(ExchangePropertyKey.STEP_ID, (Object)this.stepId);
        EventHelper.notifyStepStarted(exchange2.getContext(), exchange2, this.stepId);
        return super.process(exchange2, sync -> {
            boolean failed = exchange2.isFailed();
            try {
                if (failed) {
                    EventHelper.notifyStepFailed(exchange2.getContext(), exchange2, this.stepId);
                } else {
                    EventHelper.notifyStepDone(exchange2.getContext(), exchange2, this.stepId);
                }
            }
            catch (Exception t) {
                LOG.warn("Exception occurred during event notification. This exception will be ignored.", (Throwable)t);
            }
            finally {
                if (oldStepId != null) {
                    exchange2.setProperty(ExchangePropertyKey.STEP_ID, oldStepId);
                } else {
                    exchange2.removeProperty(ExchangePropertyKey.STEP_ID);
                }
                callback.done(sync);
            }
        });
    }

    @Override
    public String getTraceLabel() {
        return "step";
    }
}

