/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;

public abstract class AbstractListAggregationStrategy<V>
implements AggregationStrategy {
    public abstract V getValue(Exchange var1);

    public boolean isStoreAsBodyOnCompletion() {
        return true;
    }

    @Override
    public void onCompletion(Exchange exchange2) {
        List list;
        if (exchange2 != null && this.isStoreAsBodyOnCompletion() && (list = (List)exchange2.removeProperty(ExchangePropertyKey.GROUPED_EXCHANGE)) != null) {
            exchange2.getIn().setBody(list);
        }
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        V value;
        List<V> list = oldExchange == null ? this.getList(newExchange) : this.getList(oldExchange);
        if (newExchange != null && (value = this.getValue(newExchange)) != null) {
            list.add(value);
        }
        return oldExchange != null ? oldExchange : newExchange;
    }

    private List<V> getList(Exchange exchange2) {
        GroupedExchangeList list = exchange2.getProperty(ExchangePropertyKey.GROUPED_EXCHANGE, List.class);
        if (list == null) {
            list = new GroupedExchangeList();
            exchange2.setProperty(ExchangePropertyKey.GROUPED_EXCHANGE, list);
        }
        return list;
    }

    private static final class GroupedExchangeList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;

        private GroupedExchangeList() {
        }

        @Override
        public String toString() {
            return "List<Exchange>(" + this.size() + " elements)";
        }
    }
}

