/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public final class ShareUnitOfWorkAggregationStrategy
extends ServiceSupport
implements AggregationStrategy,
CamelContextAware {
    private final AggregationStrategy strategy;
    private CamelContext camelContext;

    public ShareUnitOfWorkAggregationStrategy(AggregationStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        CamelContextAware.trySetCamelContext(this.strategy, camelContext);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public AggregationStrategy getDelegate() {
        return this.strategy;
    }

    @Override
    public boolean canPreComplete() {
        return this.strategy.canPreComplete();
    }

    @Override
    public boolean preComplete(Exchange oldExchange, Exchange newExchange) {
        return this.strategy.preComplete(oldExchange, newExchange);
    }

    @Override
    public void onCompletion(Exchange exchange2) {
        this.strategy.onCompletion(exchange2);
    }

    @Override
    public void onCompletion(Exchange exchange2, Exchange inputExchange) {
        this.strategy.onCompletion(exchange2, inputExchange);
    }

    @Override
    public void timeout(Exchange exchange2, int index, int total, long timeout) {
        this.strategy.timeout(exchange2, index, total, timeout);
    }

    @Override
    public void onOptimisticLockFailure(Exchange oldExchange, Exchange newExchange) {
        this.strategy.onOptimisticLockFailure(oldExchange, newExchange);
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        Exchange answer = this.strategy.aggregate(oldExchange, newExchange);
        this.propagateFailure(answer, newExchange);
        return answer;
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange, Exchange inputExchange) {
        Exchange answer = this.strategy.aggregate(oldExchange, newExchange, inputExchange);
        this.propagateFailure(answer, newExchange);
        return answer;
    }

    private void propagateFailure(Exchange answer, Exchange newExchange) {
        if (newExchange.isFailed() || newExchange.isRollbackOnly() || newExchange.isRollbackOnlyLast() || newExchange.getExchangeExtension().isErrorHandlerHandledSet() && newExchange.getExchangeExtension().isErrorHandlerHandled()) {
            if (newExchange.getException() != null) {
                answer.setException(newExchange.getException());
            }
            if (newExchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT) != null) {
                answer.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, newExchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT));
            }
            if (newExchange.getProperty(ExchangePropertyKey.FAILURE_ENDPOINT) != null) {
                answer.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, newExchange.getProperty(ExchangePropertyKey.FAILURE_ENDPOINT));
            }
            if (newExchange.getProperty(ExchangePropertyKey.FAILURE_ROUTE_ID) != null) {
                answer.setProperty(ExchangePropertyKey.FAILURE_ROUTE_ID, newExchange.getProperty(ExchangePropertyKey.FAILURE_ROUTE_ID));
            }
            if (newExchange.getExchangeExtension().getErrorHandlerHandled() != null) {
                answer.getExchangeExtension().setErrorHandlerHandled(newExchange.getExchangeExtension().getErrorHandlerHandled());
            }
            answer.getExchangeExtension().setFailureHandled(newExchange.getExchangeExtension().isFailureHandled());
        }
    }

    public String toString() {
        return "ShareUnitOfWorkAggregationStrategy";
    }

    @Override
    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.strategy);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.strategy);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.strategy);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.strategy);
    }
}

