/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.builder.ExpressionBuilder;

@Metadata(label="bean", description="Aggregate result of pick expression into a single combined Exchange holding all the aggregated bodies in a String as the message body. This aggregation strategy can used in combination with Splitter to batch messages", annotations={"interfaceName=org.apache.camel.AggregationStrategy"})
@Configurer(metadataOnly=true)
public class StringAggregationStrategy
implements AggregationStrategy {
    @Metadata(description="Delimiter used for joining strings together.")
    private String delimiter = "";
    private Expression pickExpression = ExpressionBuilder.bodyExpression();

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Expression getPickExpression() {
        return this.pickExpression;
    }

    public void setPickExpression(Expression pickExpression) {
        this.pickExpression = pickExpression;
    }

    public StringAggregationStrategy delimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public StringAggregationStrategy pick(Expression expression) {
        this.pickExpression = expression;
        return this;
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        String pick;
        StringBuffer result;
        StringBuilder value = new StringBuilder(512);
        if (oldExchange == null) {
            result = StringAggregationStrategy.getStringBuffer(newExchange);
        } else {
            result = StringAggregationStrategy.getStringBuffer(oldExchange);
            value.append(this.delimiter);
        }
        if (newExchange != null && (pick = this.pickExpression.evaluate(newExchange, String.class)) != null) {
            value.append(pick);
            result.append((CharSequence)value);
        }
        return oldExchange != null ? oldExchange : newExchange;
    }

    @Override
    public void onCompletion(Exchange exchange2) {
        StringBuffer stringBuffer;
        if (exchange2 != null && (stringBuffer = (StringBuffer)exchange2.removeProperty(ExchangePropertyKey.GROUPED_EXCHANGE)) != null) {
            exchange2.getIn().setBody(stringBuffer.toString());
        }
    }

    private static StringBuffer getStringBuffer(Exchange exchange2) {
        StringBuffer stringBuffer = exchange2.getProperty(ExchangePropertyKey.GROUPED_EXCHANGE, StringBuffer.class);
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
            exchange2.setProperty(ExchangePropertyKey.GROUPED_EXCHANGE, (Object)stringBuffer);
        }
        return stringBuffer;
    }
}

