/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.processor.resequencer.ExpressionResultComparator;

public class DefaultExchangeComparator
implements ExpressionResultComparator {
    private Expression expression;

    @Override
    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public boolean predecessor(Exchange o1, Exchange o2) {
        long n2;
        long n1 = this.getSequenceNumber(o1);
        return n1 == (n2 = this.getSequenceNumber(o2).longValue()) - 1L;
    }

    @Override
    public boolean successor(Exchange o1, Exchange o2) {
        long n1 = this.getSequenceNumber(o1);
        long n2 = this.getSequenceNumber(o2);
        return n2 == n1 - 1L;
    }

    @Override
    public int compare(Exchange o1, Exchange o2) {
        Long n1 = this.getSequenceNumber(o1);
        Long n2 = this.getSequenceNumber(o2);
        return n1.compareTo(n2);
    }

    private Long getSequenceNumber(Exchange exchange2) {
        return this.expression.evaluate(exchange2, Long.class);
    }

    @Override
    public boolean isValid(Exchange exchange2) {
        Long num = null;
        try {
            num = this.expression.evaluate(exchange2, Long.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num != null;
    }

    public String toString() {
        return "Comparator[" + this.expression + "]";
    }
}

