/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.function.BiFunction;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ClaimCheckDefinition;
import org.apache.camel.model.ClaimCheckOperation;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.ClaimCheckProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.AggregationStrategyBiFunctionAdapter;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.util.ObjectHelper;

public class ClaimCheckReifier
extends ProcessorReifier<ClaimCheckDefinition> {
    public ClaimCheckReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ClaimCheckDefinition)ClaimCheckDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        String filter2;
        ObjectHelper.notNull(((ClaimCheckDefinition)this.definition).getOperation(), "operation", this);
        ClaimCheckProcessor claim = new ClaimCheckProcessor();
        claim.setOperation(this.parse(ClaimCheckOperation.class, ((ClaimCheckDefinition)this.definition).getOperation()).name());
        claim.setKey(this.parseString(((ClaimCheckDefinition)this.definition).getKey()));
        claim.setFilter(this.parseString(((ClaimCheckDefinition)this.definition).getFilter()));
        AggregationStrategy strategy = this.createAggregationStrategy();
        if (strategy != null) {
            claim.setAggregationStrategy(strategy);
        }
        if ((filter2 = this.parseString(((ClaimCheckDefinition)this.definition).getFilter())) != null && strategy != null) {
            throw new IllegalArgumentException("Cannot use both filter and custom aggregation strategy on ClaimCheck EIP");
        }
        if (filter2 != null) {
            boolean bl;
            Iterable<String> it = org.apache.camel.support.ObjectHelper.createIterable(filter2, ",");
            boolean includeBody = false;
            boolean excludeBody = false;
            for (String o : it) {
                String pattern = o.toString();
                if ("body".equals(pattern) || "+body".equals(pattern)) {
                    includeBody = true;
                    continue;
                }
                if (!"-body".equals(pattern)) continue;
                excludeBody = true;
            }
            if (includeBody && excludeBody) {
                throw new IllegalArgumentException("Cannot have both include and exclude body at the same time in the filter: " + ((ClaimCheckDefinition)this.definition).getFilter());
            }
            boolean includeHeaders = false;
            boolean excludeHeaders = false;
            for (Object e : it) {
                String pattern = e.toString();
                if ("headers".equals(pattern) || "+headers".equals(pattern)) {
                    includeHeaders = true;
                    continue;
                }
                if (!"-headers".equals(pattern)) continue;
                excludeHeaders = true;
            }
            if (includeHeaders && excludeHeaders) {
                throw new IllegalArgumentException("Cannot have both include and exclude headers at the same time in the filter: " + ((ClaimCheckDefinition)this.definition).getFilter());
            }
            boolean includeHeader = false;
            boolean bl2 = false;
            for (String o : it) {
                String pattern = o.toString();
                if (pattern.startsWith("header:") || pattern.startsWith("+header:")) {
                    includeHeader = true;
                    continue;
                }
                if (!pattern.startsWith("-header:")) continue;
                bl = true;
            }
            if (includeHeader && bl) {
                throw new IllegalArgumentException("Cannot have both include and exclude header at the same time in the filter: " + ((ClaimCheckDefinition)this.definition).getFilter());
            }
        }
        return claim;
    }

    private AggregationStrategy createAggregationStrategy() {
        AggregationStrategy strategy = ((ClaimCheckDefinition)this.definition).getAggregationStrategyBean();
        String ref = this.parseString(((ClaimCheckDefinition)this.definition).getAggregationStrategy());
        if (strategy == null && ref != null) {
            Object aggStrategy = this.lookupByName(ref);
            if (aggStrategy instanceof AggregationStrategy) {
                AggregationStrategy aggregationStrategy;
                strategy = aggregationStrategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy instanceof BiFunction) {
                BiFunction biFunction = (BiFunction)aggStrategy;
                strategy = new AggregationStrategyBiFunctionAdapter(biFunction);
            } else if (aggStrategy != null) {
                strategy = new AggregationStrategyBeanAdapter(aggStrategy, ((ClaimCheckDefinition)this.definition).getAggregationStrategyMethodName());
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((ClaimCheckDefinition)this.definition).getAggregationStrategy());
            }
        }
        CamelContextAware.trySetCamelContext(strategy, this.camelContext);
        return strategy;
    }
}

