/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.util.ObjectHelper;

public final class ExpressionToPredicateAdapter
implements Predicate,
CamelContextAware,
PropertyConfigurerAware {
    private final Expression expression;

    public ExpressionToPredicateAdapter(Expression expression) {
        this.expression = expression;
    }

    @Override
    public boolean matches(Exchange exchange2) {
        Expression expression = this.expression;
        if (expression instanceof Predicate) {
            Predicate predicate = (Predicate)((Object)expression);
            return predicate.matches(exchange2);
        }
        Object value = this.expression.evaluate(exchange2, Object.class);
        return ObjectHelper.evaluateValuePredicate(value);
    }

    public String toString() {
        return this.expression.toString();
    }

    public static Predicate toPredicate(Expression expression) {
        if (expression instanceof Predicate) {
            Predicate predicate = (Predicate)((Object)expression);
            return predicate;
        }
        return new ExpressionToPredicateAdapter(expression);
    }

    @Override
    public void init(CamelContext context) {
        this.expression.init(context);
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        CamelContextAware.trySetCamelContext(this.expression, camelContext);
    }

    @Override
    public CamelContext getCamelContext() {
        Expression expression = this.expression;
        if (expression instanceof CamelContextAware) {
            CamelContextAware camelContext = (CamelContextAware)((Object)expression);
            return camelContext.getCamelContext();
        }
        return null;
    }

    @Override
    public PropertyConfigurer getPropertyConfigurer(Object instance) {
        Expression expression = this.expression;
        if (expression instanceof PropertyConfigurer) {
            PropertyConfigurer propertyConfigurer = (PropertyConfigurer)((Object)expression);
            return propertyConfigurer;
        }
        expression = this.expression;
        if (expression instanceof PropertyConfigurerAware) {
            PropertyConfigurerAware propertyConfigurer = (PropertyConfigurerAware)((Object)expression);
            return propertyConfigurer.getPropertyConfigurer(this.expression);
        }
        return null;
    }
}

