/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationRouteAware;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.OrderedComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnitOfWorkHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UnitOfWorkHelper.class);

    private UnitOfWorkHelper() {
    }

    public static void doneUow(UnitOfWork uow, Exchange exchange2) {
        if (uow == null) {
            return;
        }
        try {
            uow.done(exchange2);
        }
        catch (Exception e) {
            LOG.warn("Exception occurred during done UnitOfWork for Exchange: {}. This exception will be ignored.", (Object)exchange2.getExchangeId(), (Object)e);
        }
    }

    public static void doneSynchronizations(Exchange exchange2, List<Synchronization> synchronizations) {
        if (synchronizations == null || synchronizations.isEmpty()) {
            return;
        }
        if (synchronizations.size() > 1) {
            List<Synchronization> copy = UnitOfWorkHelper.safeCopy(synchronizations);
            boolean failed = exchange2.isFailed();
            for (Synchronization synchronization : copy) {
                UnitOfWorkHelper.doneSynchronization(synchronization, exchange2, failed);
            }
        } else {
            UnitOfWorkHelper.doneSynchronization(synchronizations.get(0), exchange2, exchange2.isFailed());
        }
    }

    private static void doneSynchronization(Synchronization synchronization, Exchange exchange2, boolean failed) {
        try {
            if (failed) {
                LOG.trace("Invoking synchronization.onFailure: {} with {}", (Object)synchronization, (Object)exchange2);
                synchronization.onFailure(exchange2);
            } else {
                LOG.trace("Invoking synchronization.onComplete: {} with {}", (Object)synchronization, (Object)exchange2);
                synchronization.onComplete(exchange2);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception occurred during onCompletion. This exception will be ignored.", (Throwable)e);
        }
    }

    public static void beforeRouteSynchronizations(Route route, Exchange exchange2, List<Synchronization> synchronizations, Logger log) {
        List<Synchronization> copy = UnitOfWorkHelper.safeCopy(synchronizations);
        UnitOfWorkHelper.invokeSynchronizationCallbacks(route, exchange2, log, copy);
    }

    private static List<Synchronization> safeCopy(List<Synchronization> synchronizations) {
        ArrayList<Synchronization> copy = new ArrayList<Synchronization>(synchronizations);
        if (copy.size() > 1) {
            Collections.reverse(copy);
            copy.sort(OrderedComparator.get());
        }
        return copy;
    }

    private static void invokeSynchronizationCallbacks(Route route, Exchange exchange2, Logger log, List<Synchronization> copy) {
        for (Synchronization synchronization : copy) {
            SynchronizationRouteAware routeSynchronization = synchronization.getRouteSynchronization();
            if (routeSynchronization == null) continue;
            try {
                log.trace("Invoking synchronization.onBeforeRoute: {} with {}", (Object)synchronization, (Object)exchange2);
                routeSynchronization.onBeforeRoute(route, exchange2);
            }
            catch (Exception e) {
                log.warn("Exception occurred during onBeforeRoute. This exception will be ignored.", (Throwable)e);
            }
        }
    }

    public static void afterRouteSynchronizations(Route route, Exchange exchange2, List<Synchronization> synchronizations, Logger log) {
        List<Synchronization> copy = UnitOfWorkHelper.safeCopy(synchronizations);
        for (Synchronization synchronization : copy) {
            SynchronizationRouteAware routeSynchronization = synchronization.getRouteSynchronization();
            if (routeSynchronization == null) continue;
            try {
                log.trace("Invoking synchronization.onAfterRoute: {} with {}", (Object)synchronization, (Object)exchange2);
                routeSynchronization.onAfterRoute(route, exchange2);
            }
            catch (Exception e) {
                log.warn("Exception occurred during onAfterRoute. This exception will be ignored.", (Throwable)e);
            }
        }
    }
}

