/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.builder;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.LanguageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.builder.BinaryPredicateSupport;
import org.apache.camel.support.builder.ExpressionBuilder;

public class PredicateBuilder {
    public static Predicate toPredicate(Expression expression) {
        return ExpressionToPredicateAdapter.toPredicate(expression);
    }

    public static Predicate not(final Predicate predicate) {
        org.apache.camel.util.ObjectHelper.notNull(predicate, "predicate");
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange2) {
                return !predicate.matches(exchange2);
            }

            @Override
            public void init(CamelContext camelContext) {
                predicate.initPredicate(camelContext);
            }

            public String toString() {
                return "not (" + predicate + ")";
            }
        };
    }

    public static Predicate and(final Predicate left, final Predicate right) {
        org.apache.camel.util.ObjectHelper.notNull(left, "left");
        org.apache.camel.util.ObjectHelper.notNull(right, "right");
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange2) {
                return left.matches(exchange2) && right.matches(exchange2);
            }

            @Override
            public void init(CamelContext camelContext) {
                left.initPredicate(camelContext);
                right.initPredicate(camelContext);
            }

            public String toString() {
                return "(" + left + ") and (" + right + ")";
            }
        };
    }

    public static Predicate or(final Predicate left, final Predicate right) {
        org.apache.camel.util.ObjectHelper.notNull(left, "left");
        org.apache.camel.util.ObjectHelper.notNull(right, "right");
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange2) {
                return left.matches(exchange2) || right.matches(exchange2);
            }

            @Override
            public void init(CamelContext camelContext) {
                left.initPredicate(camelContext);
                right.initPredicate(camelContext);
            }

            public String toString() {
                return "(" + left + ") or (" + right + ")";
            }
        };
    }

    public static Predicate or(List<Predicate> predicates) {
        Predicate answer = null;
        for (Predicate predicate : predicates) {
            if (answer == null) {
                answer = predicate;
                continue;
            }
            answer = PredicateBuilder.or(answer, predicate);
        }
        return answer;
    }

    public static Predicate or(Predicate ... predicates) {
        return PredicateBuilder.or(Arrays.asList(predicates));
    }

    public static Predicate in(final Predicate ... predicates) {
        org.apache.camel.util.ObjectHelper.notNull(predicates, "predicates");
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange2) {
                for (Predicate in : predicates) {
                    if (!in.matches(exchange2)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void init(CamelContext camelContext) {
                for (Predicate in : predicates) {
                    in.initPredicate(camelContext);
                }
            }

            public String toString() {
                return "in (" + Arrays.asList(predicates) + ")";
            }
        };
    }

    public static Predicate in(List<Predicate> predicates) {
        return PredicateBuilder.in(predicates.toArray(new Predicate[0]));
    }

    public static Predicate isEqualTo(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceEquals(exchange2.getContext().getTypeConverter(), leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "==";
            }
        };
    }

    public static Predicate isEqualToIgnoreCase(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceEquals(exchange2.getContext().getTypeConverter(), leftValue, rightValue, true);
            }

            @Override
            protected String getOperationText() {
                return "=~";
            }
        };
    }

    public static Predicate isNotEqualTo(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return false;
                }
                if (leftValue == null || rightValue == null) {
                    return true;
                }
                return ObjectHelper.typeCoerceNotEquals(exchange2.getContext().getTypeConverter(), leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "!=";
            }
        };
    }

    public static Predicate isLessThan(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceCompare(exchange2.getContext().getTypeConverter(), leftValue, rightValue) < 0;
            }

            @Override
            protected String getOperationText() {
                return "<";
            }
        };
    }

    public static Predicate isLessThanOrEqualTo(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceCompare(exchange2.getContext().getTypeConverter(), leftValue, rightValue) <= 0;
            }

            @Override
            protected String getOperationText() {
                return "<=";
            }
        };
    }

    public static Predicate isGreaterThan(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return false;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceCompare(exchange2.getContext().getTypeConverter(), leftValue, rightValue) > 0;
            }

            @Override
            protected String getOperationText() {
                return ">";
            }
        };
    }

    public static Predicate isGreaterThanOrEqualTo(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceCompare(exchange2.getContext().getTypeConverter(), leftValue, rightValue) >= 0;
            }

            @Override
            protected String getOperationText() {
                return ">=";
            }
        };
    }

    public static Predicate contains(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceContains(exchange2.getContext().getTypeConverter(), leftValue, rightValue, false);
            }

            @Override
            protected String getOperationText() {
                return "contains";
            }
        };
    }

    public static Predicate containsIgnoreCase(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceContains(exchange2.getContext().getTypeConverter(), leftValue, rightValue, true);
            }

            @Override
            protected String getOperationText() {
                return "~~";
            }
        };
    }

    public static Predicate isNull(Expression expression) {
        return new BinaryPredicateSupport(expression, ExpressionBuilder.constantExpression(null)){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                if (leftValue == null) {
                    return true;
                }
                return ObjectHelper.typeCoerceEquals(exchange2.getContext().getTypeConverter(), leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "is";
            }
        };
    }

    public static Predicate isNotNull(Expression expression) {
        return new BinaryPredicateSupport(expression, ExpressionBuilder.constantExpression(null)){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                if (leftValue != null) {
                    return true;
                }
                return ObjectHelper.typeCoerceNotEquals(exchange2.getContext().getTypeConverter(), leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "is not";
            }
        };
    }

    public static Predicate isInstanceOf(final Expression expression, final Class<?> type) {
        org.apache.camel.util.ObjectHelper.notNull(expression, "expression");
        org.apache.camel.util.ObjectHelper.notNull(type, "type");
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange2) {
                Object value = expression.evaluate(exchange2, Object.class);
                return type.isInstance(value);
            }

            @Override
            public void init(CamelContext camelContext) {
                expression.init(camelContext);
            }

            public String toString() {
                return expression + " instanceof " + type.getCanonicalName();
            }
        };
    }

    public static Predicate startsWith(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                return LanguageHelper.startsWith(exchange2, leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "startsWith";
            }
        };
    }

    public static Predicate endsWith(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange2, Object leftValue, Object rightValue) {
                return LanguageHelper.endsWith(exchange2, leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "endsWith";
            }
        };
    }

    public static Predicate regex(Expression expression, String regex) {
        return PredicateBuilder.regex(expression, Pattern.compile(regex));
    }

    public static Predicate regex(final Expression expression, final Pattern pattern) {
        org.apache.camel.util.ObjectHelper.notNull(expression, "expression");
        org.apache.camel.util.ObjectHelper.notNull(pattern, "pattern");
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange2) {
                String value = expression.evaluate(exchange2, String.class);
                if (value != null) {
                    Matcher matcher = pattern.matcher(value);
                    return matcher.matches();
                }
                return false;
            }

            @Override
            public void init(CamelContext camelContext) {
                expression.init(camelContext);
            }

            public String toString() {
                return expression + ".matches('" + pattern + "')";
            }
        };
    }

    public static Predicate and(List<Predicate> predicates) {
        Predicate answer = null;
        for (Predicate predicate : predicates) {
            if (answer == null) {
                answer = predicate;
                continue;
            }
            answer = PredicateBuilder.and(answer, predicate);
        }
        return answer;
    }

    public static Predicate and(Predicate ... predicates) {
        return PredicateBuilder.and(Arrays.asList(predicates));
    }

    public static Predicate constant(final boolean answer) {
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange2) {
                return answer;
            }

            public String toString() {
                return String.valueOf(answer);
            }
        };
    }
}

