/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.scan;

import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;

public class PackageScanHelper {
    private PackageScanHelper() {
    }

    public static void registerBeans(CamelContext camelContext, Set<String> packages) {
        Registry registry;
        if (packages != null && !packages.isEmpty() && (registry = camelContext.getRegistry()) != null) {
            PackageScanClassResolver scanner = camelContext.getCamelContextExtension().getContextPlugin(PackageScanClassResolver.class);
            Injector injector = camelContext.getInjector();
            if (scanner != null && injector != null) {
                HashMap created = new HashMap();
                HashMap initMethods = new HashMap();
                HashSet lazy = new HashSet();
                for (String pkg : packages) {
                    Class c;
                    String beanName;
                    BindToRegistry ann;
                    Set<Class<?>> classes = scanner.findAnnotated(BindToRegistry.class, pkg);
                    for (Class<?> clazz : classes) {
                        ann = clazz.getAnnotation(BindToRegistry.class);
                        if (ann != null && ann.lazy()) {
                            lazy.add(clazz);
                            continue;
                        }
                        Object b = injector.newInstance(clazz, false);
                        if (b == null) continue;
                        created.put(clazz, b);
                    }
                    for (Class<Object> clazz : lazy) {
                        ann = clazz.getAnnotation(BindToRegistry.class);
                        if (ann == null) continue;
                        String name = ann.value();
                        if (org.apache.camel.util.ObjectHelper.isEmpty(name)) {
                            name = clazz.getSimpleName();
                        }
                        beanName = clazz.getName();
                        Supplier<Object> bean2 = () -> {
                            Object answer = injector.newInstance(c2);
                            if (answer != null && ann.beanPostProcess()) {
                                try {
                                    CamelBeanPostProcessor beanPostProcessor = PluginHelper.getBeanPostProcessor(camelContext);
                                    beanPostProcessor.postProcessBeforeInitialization(answer, beanName);
                                    beanPostProcessor.postProcessAfterInitialization(answer, beanName);
                                }
                                catch (Exception e) {
                                    throw RuntimeCamelException.wrapRuntimeException(e);
                                }
                            }
                            return answer;
                        };
                        Runnable task = PluginHelper.getDependencyInjectionAnnotationFactory(camelContext).createBindToRegistryFactory(name, bean2, clazz, beanName, false, null, null);
                        task.run();
                    }
                    for (Map.Entry entry : created.entrySet()) {
                        String destroyMethod;
                        c = (Class)entry.getKey();
                        BindToRegistry ann2 = c.getAnnotation(BindToRegistry.class);
                        if (ann2 == null) continue;
                        String name = ann2.value();
                        if (org.apache.camel.util.ObjectHelper.isEmpty(name)) {
                            name = c.getSimpleName();
                        }
                        Object bean2 = entry.getValue();
                        String beanName2 = c.getName();
                        String initMethod = ann2.initMethod();
                        if (org.apache.camel.util.ObjectHelper.isEmpty(initMethod) && bean2 instanceof Service) {
                            initMethod = "start";
                        }
                        if (org.apache.camel.util.ObjectHelper.isEmpty(destroyMethod = ann2.destroyMethod()) && bean2 instanceof Service) {
                            destroyMethod = "stop";
                        } else if (org.apache.camel.util.ObjectHelper.isEmpty(destroyMethod) && bean2 instanceof Closeable) {
                            destroyMethod = "close";
                        }
                        Runnable task = PluginHelper.getDependencyInjectionAnnotationFactory(camelContext).createBindToRegistryFactory(name, bean2, c, beanName2, false, null, destroyMethod);
                        if (org.apache.camel.util.ObjectHelper.isNotEmpty(initMethod)) {
                            initMethods.put(bean2, initMethod);
                        }
                        task.run();
                    }
                    for (Map.Entry entry : created.entrySet()) {
                        c = (Class)entry.getKey();
                        Object bean3 = entry.getValue();
                        beanName = c.getName();
                        try {
                            PluginHelper.getBeanPostProcessor(camelContext).postProcessBeforeInitialization(bean3, beanName);
                            PluginHelper.getBeanPostProcessor(camelContext).postProcessAfterInitialization(bean3, beanName);
                        }
                        catch (Exception e) {
                            throw new RuntimeCamelException("Error post-processing bean: " + beanName, e);
                        }
                    }
                    for (Map.Entry entry : initMethods.entrySet()) {
                        Object bean4 = entry.getKey();
                        String method = (String)entry.getValue();
                        try {
                            ObjectHelper.invokeMethodSafe(method, bean4, new Object[0]);
                        }
                        catch (Exception e) {
                            throw RuntimeCamelException.wrapRuntimeCamelException(e);
                        }
                    }
                }
            }
        }
    }
}

