/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.ReaderCache;
import org.apache.camel.util.IOHelper;

public final class StreamSourceCache
extends StreamSource
implements StreamCache {
    private final StreamCache streamCache;
    private final ReaderCache readCache;

    public StreamSourceCache(StreamSource source, Exchange exchange2) throws IOException {
        if (source.getInputStream() != null) {
            CachedOutputStream cos = new CachedOutputStream(exchange2);
            IOHelper.copyAndCloseInput(source.getInputStream(), cos);
            this.streamCache = cos.newStreamCache();
            this.readCache = null;
            this.setSystemId(source.getSystemId());
            this.setInputStream((InputStream)((Object)this.streamCache));
        } else if (source.getReader() != null) {
            String data = exchange2.getContext().getTypeConverter().convertTo(String.class, exchange2, source.getReader());
            this.readCache = new ReaderCache(data);
            this.streamCache = null;
            this.setReader(this.readCache);
        } else {
            this.streamCache = null;
            this.readCache = null;
        }
    }

    public StreamSourceCache(StreamCache streamCache) {
        this.streamCache = streamCache;
        if (streamCache instanceof InputStream) {
            InputStream inputStream = (InputStream)((Object)streamCache);
            this.setInputStream(inputStream);
            this.readCache = null;
        } else if (streamCache instanceof ReaderCache) {
            ReaderCache readerCache;
            this.readCache = readerCache = (ReaderCache)streamCache;
            this.setReader((Reader)((Object)streamCache));
        } else {
            this.readCache = null;
        }
    }

    @Override
    public void reset() {
        if (this.streamCache != null) {
            this.streamCache.reset();
        }
        if (this.readCache != null) {
            this.readCache.reset();
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.streamCache != null) {
            this.streamCache.writeTo(os);
        } else if (this.readCache != null) {
            this.readCache.writeTo(os);
        }
    }

    @Override
    public StreamCache copy(Exchange exchange2) throws IOException {
        if (this.streamCache != null) {
            return new StreamSourceCache(this.streamCache.copy(exchange2));
        }
        if (this.readCache != null) {
            return new StreamSourceCache(this.readCache.copy(exchange2));
        }
        return null;
    }

    @Override
    public boolean inMemory() {
        if (this.streamCache != null) {
            return this.streamCache.inMemory();
        }
        if (this.readCache != null) {
            return this.readCache.inMemory();
        }
        return true;
    }

    @Override
    public long length() {
        if (this.streamCache != null) {
            return this.streamCache.length();
        }
        if (this.readCache != null) {
            return this.readCache.length();
        }
        return 0L;
    }

    @Override
    public long position() {
        return -1L;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0L;
    }
}

