/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2.runtime.reflect;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.glassfish.jaxb.core.v2.ClassFactory;
import org.glassfish.jaxb.runtime.api.AccessorException;
import org.glassfish.jaxb.runtime.v2.runtime.Coordinator;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.Accessor;

final class AdaptedAccessor<BeanT, InMemValueT, OnWireValueT>
extends Accessor<BeanT, OnWireValueT> {
    private final Accessor<BeanT, InMemValueT> core;
    private final Class<? extends XmlAdapter<OnWireValueT, InMemValueT>> adapter;
    private XmlAdapter<OnWireValueT, InMemValueT> staticAdapter;

    AdaptedAccessor(Class<OnWireValueT> targetType, Accessor<BeanT, InMemValueT> extThis, Class<? extends XmlAdapter<OnWireValueT, InMemValueT>> adapter) {
        super(targetType);
        this.core = extThis;
        this.adapter = adapter;
    }

    @Override
    public boolean isAdapted() {
        return true;
    }

    @Override
    public OnWireValueT get(BeanT bean2) throws AccessorException {
        InMemValueT v = this.core.get(bean2);
        XmlAdapter<OnWireValueT, InMemValueT> a = this.getAdapter();
        try {
            return a.marshal(v);
        }
        catch (Exception e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void set(BeanT bean2, OnWireValueT o) throws AccessorException {
        XmlAdapter<OnWireValueT, InMemValueT> a = this.getAdapter();
        try {
            this.core.set(bean2, o == null ? null : (Object)a.unmarshal(o));
        }
        catch (Exception e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public Object getUnadapted(BeanT bean2) throws AccessorException {
        return this.core.getUnadapted(bean2);
    }

    @Override
    public void setUnadapted(BeanT bean2, Object value) throws AccessorException {
        this.core.setUnadapted(bean2, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlAdapter<OnWireValueT, InMemValueT> getAdapter() {
        Coordinator coordinator = Coordinator._getInstance();
        if (coordinator != null) {
            return coordinator.getAdapter(this.adapter);
        }
        AdaptedAccessor adaptedAccessor = this;
        synchronized (adaptedAccessor) {
            if (this.staticAdapter == null) {
                this.staticAdapter = ClassFactory.create(this.adapter);
            }
        }
        return this.staticAdapter;
    }
}

