/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public final class MethodEndpoint {
    private final Object bean;
    private final Method method;
    private final BeanFactory beanFactory;

    public MethodEndpoint(Object bean2, Method method) {
        Assert.notNull(bean2, "bean must not be null");
        Assert.notNull((Object)method, "method must not be null");
        this.bean = bean2;
        this.method = method;
        this.beanFactory = null;
    }

    public MethodEndpoint(Object bean2, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Assert.notNull(bean2, "bean must not be null");
        Assert.notNull((Object)methodName, "method must not be null");
        this.bean = bean2;
        this.method = bean2.getClass().getMethod(methodName, parameterTypes);
        this.beanFactory = null;
    }

    public MethodEndpoint(String beanName, BeanFactory beanFactory, Method method) {
        Assert.hasText(beanName, "'beanName' must not be null");
        Assert.notNull((Object)beanFactory, "'beanFactory' must not be null");
        Assert.notNull((Object)method, "'method' must not be null");
        Assert.isTrue(beanFactory.containsBean(beanName), "Bean factory [" + beanFactory + "] does not contain bean with name [" + beanName + "]");
        this.bean = beanName;
        this.beanFactory = beanFactory;
        this.method = method;
    }

    public Object getBean() {
        if (this.beanFactory != null && this.bean instanceof String) {
            String beanName = (String)this.bean;
            return this.beanFactory.getBean(beanName);
        }
        return this.bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public MethodParameter[] getMethodParameters() {
        int parameterCount = this.getMethod().getParameterTypes().length;
        MethodParameter[] parameters = new MethodParameter[parameterCount];
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            parameters[i2] = new MethodParameter(this.getMethod(), i2);
        }
        return parameters;
    }

    public MethodParameter getReturnType() {
        return new MethodParameter(this.method, -1);
    }

    public Object invoke(Object ... args) throws Exception {
        Object endpoint = this.getBean();
        ReflectionUtils.makeAccessible(this.method);
        try {
            return this.method.invoke(endpoint, args);
        }
        catch (InvocationTargetException ex) {
            this.handleInvocationTargetException(ex);
            throw new IllegalStateException("Unexpected exception thrown by method - " + ex.getTargetException().getClass().getName() + ": " + ex.getTargetException().getMessage());
        }
    }

    private void handleInvocationTargetException(InvocationTargetException ex) throws Exception {
        Throwable targetException = ex.getTargetException();
        if (targetException instanceof RuntimeException) {
            throw (RuntimeException)targetException;
        }
        if (targetException instanceof Error) {
            throw (Error)targetException;
        }
        if (targetException instanceof Exception) {
            throw (Exception)targetException;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MethodEndpoint) {
            MethodEndpoint other = (MethodEndpoint)o;
            return this.bean.equals(other.bean) && this.method.equals(other.method);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.bean.hashCode() + this.method.hashCode();
    }

    public String toString() {
        return this.method.toGenericString();
    }
}

