/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.springframework.core.MethodParameter;
import org.springframework.util.xml.StaxUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.adapter.method.MethodArgumentResolver;
import org.springframework.ws.server.endpoint.annotation.RequestPayload;
import org.springframework.xml.XMLInputFactoryUtils;
import org.springframework.xml.transform.TransformerObjectSupport;

public class StaxPayloadMethodArgumentResolver
extends TransformerObjectSupport
implements MethodArgumentResolver {
    private final XMLInputFactory inputFactory = this.createXmlInputFactory();

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.getParameterAnnotation(RequestPayload.class) == null) {
            return false;
        }
        Class<?> parameterType = parameter.getParameterType();
        return XMLStreamReader.class.equals(parameterType) || XMLEventReader.class.equals(parameterType);
    }

    @Override
    public Object resolveArgument(MessageContext messageContext, MethodParameter parameter) throws TransformerException, XMLStreamException {
        Source source = messageContext.getRequest().getPayloadSource();
        if (source == null) {
            return null;
        }
        Class<?> parameterType = parameter.getParameterType();
        if (XMLStreamReader.class.equals(parameterType)) {
            return this.resolveStreamReader(source);
        }
        if (XMLEventReader.class.equals(parameterType)) {
            return this.resolveEventReader(source);
        }
        throw new UnsupportedOperationException();
    }

    private XMLStreamReader resolveStreamReader(Source requestSource) throws TransformerException, XMLStreamException {
        XMLEventReader eventReader;
        XMLStreamReader streamReader = null;
        if (StaxUtils.isStaxSource(requestSource) && (streamReader = StaxUtils.getXMLStreamReader(requestSource)) == null && (eventReader = StaxUtils.getXMLEventReader(requestSource)) != null) {
            try {
                streamReader = StaxUtils.createEventStreamReader(eventReader);
            }
            catch (XMLStreamException ex) {
                streamReader = null;
            }
        }
        if (streamReader == null) {
            try {
                streamReader = this.inputFactory.createXMLStreamReader(requestSource);
            }
            catch (UnsupportedOperationException | XMLStreamException ex) {
                streamReader = null;
            }
        }
        if (streamReader == null) {
            ByteArrayInputStream bis = this.convertToByteArrayInputStream(requestSource);
            streamReader = this.inputFactory.createXMLStreamReader(bis);
        }
        return streamReader;
    }

    private XMLEventReader resolveEventReader(Source requestSource) throws TransformerException, XMLStreamException {
        XMLStreamReader streamReader;
        XMLEventReader eventReader = null;
        if (StaxUtils.isStaxSource(requestSource) && (eventReader = StaxUtils.getXMLEventReader(requestSource)) == null && (streamReader = StaxUtils.getXMLStreamReader(requestSource)) != null) {
            try {
                eventReader = this.inputFactory.createXMLEventReader(streamReader);
            }
            catch (XMLStreamException ex) {
                eventReader = null;
            }
        }
        if (eventReader == null) {
            try {
                eventReader = this.inputFactory.createXMLEventReader(requestSource);
            }
            catch (UnsupportedOperationException | XMLStreamException ex) {
                eventReader = null;
            }
        }
        if (eventReader == null) {
            ByteArrayInputStream bis = this.convertToByteArrayInputStream(requestSource);
            eventReader = this.inputFactory.createXMLEventReader(bis);
        }
        return eventReader;
    }

    protected XMLInputFactory createXmlInputFactory() {
        return XMLInputFactoryUtils.newInstance();
    }

    private ByteArrayInputStream convertToByteArrayInputStream(Source source) throws TransformerException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.transform(source, new StreamResult(bos));
        return new ByteArrayInputStream(bos.toByteArray());
    }
}

